/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.errorcode;

import java.text.MessageFormat;

public enum SecurityOfficerErrorCode {
    OMRS_NOT_INITIALIZED(404, "OMAS-SECURITY-OFFICER-404-001 ", "The open metadata repository services are not initialized for server {0}", "The system is unable to connect to the open metadata property server.", "Check that the server initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    OMRS_NOT_AVAILABLE(404, "OMAS-SECURITY-OFFICER-404-002 ", "The open metadata repository services are not available for the {0} operation", "The system is unable to connect to the open metadata property server.", "Check that the server where the Security Officer OMAS is running initialized correctly and is not in the process of shutting down.  Correct any errors discovered and retry the request when the open metadata services are available."),
    NO_METADATA_COLLECTION(404, "OMAS-SECURITY-OFFICER-404-003 ", "The repository connector {0} is not returning a metadata collection object", "The system is unable to access any metadata.", "Check that the open metadata server URL is correct and the server is running.  Report the error to the system administrator."),
    SERVICE_NOT_INITIALIZED(503, "OMAS-SECURITY-OFFICER-503-001 ", "The access service has not been initialized for server {0} and can not support REST API calls", "The server has received a call to one of its open metadata access services but is unable to process it because the access service is not active for the requested server.", "If the server is supposed to have this access service activated, correct the server configuration and restart the server."),
    PUBLISH_EVENT_EXCEPTION(500, "OMAS-SECURITY-OFFICER-500-001 ", "Event {0} could not be published: {1}", "The system is unable to process the request.", "Verify the topic configuration."),
    NULL_TOPIC_CONNECTOR(400, "SECURITY-OFFICER-400-001", "Unable to send or receive events for source {0} because the connector to the OMRS Topic failed to initialize", "The local server will not connect to the cohort.", "The connection to the connector is configured in the server configuration.  Review previous error messages to determine the precise error in the start up configuration. Correct the configuration and reconnect the server to the cohort. ");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;

    private SecurityOfficerErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        return mf.format(params);
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

