/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.client;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.GovernedAsset;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.GovernedAssetListResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.GovernedAssetResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerOMASAPIResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SoftwareServerCapabilityRequestBody;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SoftwareServerCapabilityResponse;
import org.odpi.openmetadata.accessservices.securityofficer.client.GovernedAssetInterface;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GovernedAssetClient
extends FFDCRESTClient
implements GovernedAssetInterface {
    private static final Logger log = LoggerFactory.getLogger(GovernedAssetClient.class);
    private static final String BASE_PATH = "/servers/{0}/open-metadata/access-services/security-officer/users/{1}";
    private static final String GOVERNED_ASSETS_LISTS = "/assets?entityTypes={2}&offset={3}&pageSize={4}";
    private static final String GOVERNED_ASSET = "/assets/{2}";
    private static final String CREATE_SOFTWARE_SERVER = "/software-server-capabilities";
    private static final String GET_SOFTWARE_SERVER = "/software-server-capabilities/{2}";
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GovernedAssetClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernedAssetClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    @Override
    public List<GovernedAsset> getGovernedAssetList(String userId, String classification, List<String> entityTypes, Integer offset, Integer pageSize) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "getGovernedAssetList";
        log.debug("Calling method: {}", (Object)"getGovernedAssetList");
        this.invalidParameterHandler.validateUserId("getGovernedAssetList", userId);
        this.invalidParameterHandler.validatePaging(offset.intValue(), pageSize.intValue(), "getGovernedAssetList");
        GovernedAssetListResponse response = (GovernedAssetListResponse)this.callGetRESTCall("getGovernedAssetList", GovernedAssetListResponse.class, this.serverPlatformURLRoot + BASE_PATH + GOVERNED_ASSETS_LISTS, new Object[]{this.serverName, userId, classification, entityTypes, offset, pageSize});
        this.detectExceptions("getGovernedAssetList", (SecurityOfficerOMASAPIResponse)response);
        if (response != null && !CollectionUtils.isEmpty((Collection)response.getGovernedAssetList())) {
            return response.getGovernedAssetList();
        }
        return Collections.emptyList();
    }

    @Override
    public GovernedAsset getGovernedAsset(String userId, String assetGuid) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "getGovernedAsset";
        log.debug("Calling method: {}", (Object)"getGovernedAsset");
        this.invalidParameterHandler.validateUserId("getGovernedAsset", userId);
        this.invalidParameterHandler.validateGUID(assetGuid, "guid", "getGovernedAsset");
        GovernedAssetResponse response = (GovernedAssetResponse)this.callGetRESTCall("getGovernedAsset", GovernedAssetResponse.class, this.serverPlatformURLRoot + BASE_PATH + GOVERNED_ASSET, new Object[]{this.serverName, userId, assetGuid});
        this.detectExceptions("getGovernedAsset", (SecurityOfficerOMASAPIResponse)response);
        return response.getAsset();
    }

    @Override
    public String createSoftwareServerCapability(String userId, SoftwareServerCapabilityRequestBody softwareServerCapability) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "createSoftwareServerCapability";
        log.debug("Calling method: {}", (Object)"createSoftwareServerCapability");
        this.invalidParameterHandler.validateUserId("createSoftwareServerCapability", userId);
        StringResponse response = (StringResponse)this.callPostRESTCall("createSoftwareServerCapability", StringResponse.class, this.serverPlatformURLRoot + BASE_PATH + CREATE_SOFTWARE_SERVER, softwareServerCapability, new Object[]{this.serverName, userId});
        this.restExceptionHandler.detectAndThrowInvalidParameterException("createSoftwareServerCapability", (FFDCResponseBase)response);
        this.restExceptionHandler.detectAndThrowPropertyServerException("createSoftwareServerCapability", (FFDCResponseBase)response);
        this.restExceptionHandler.detectAndThrowUserNotAuthorizedException("createSoftwareServerCapability", (FFDCResponseBase)response);
        return response.getResultString();
    }

    @Override
    public SoftwareServerCapability getSoftwareServerCapabilityByGUID(String userId, String guid) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "getSoftwareServerCapabilityByGUID";
        log.debug("Calling method: {}", (Object)"getSoftwareServerCapabilityByGUID");
        this.invalidParameterHandler.validateUserId("getSoftwareServerCapabilityByGUID", userId);
        this.invalidParameterHandler.validateGUID(guid, "guid", "getSoftwareServerCapabilityByGUID");
        SoftwareServerCapabilityResponse response = (SoftwareServerCapabilityResponse)this.callGetRESTCall("getSoftwareServerCapabilityByGUID", SoftwareServerCapabilityResponse.class, this.serverPlatformURLRoot + BASE_PATH + GET_SOFTWARE_SERVER, new Object[]{this.serverName, userId, guid});
        this.detectExceptions("getSoftwareServerCapabilityByGUID", (SecurityOfficerOMASAPIResponse)response);
        return response.getServerCapability();
    }

    private void detectExceptions(String methodName, SecurityOfficerOMASAPIResponse response) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.restExceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)response);
        this.restExceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)response);
        this.restExceptionHandler.detectAndThrowUserNotAuthorizedException(methodName, (FFDCResponseBase)response);
    }
}

