/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.admin.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerEventType;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerUpdateTagEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.errorcode.SecurityOfficerErrorCode;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecurityClassification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecuritySchemaElement;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.services.SecurityOfficerRegistration;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.services.SecurityOfficerServicesInstance;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.services.SecurityOfficerServicesInstanceMap;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.utils.Builder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecurityOfficerInstanceHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityOfficerInstanceHandler.class);
    private static SecurityOfficerServicesInstanceMap instanceMap = new SecurityOfficerServicesInstanceMap();
    private Builder builder = new Builder();

    SecurityOfficerInstanceHandler() {
        SecurityOfficerRegistration.registerAccessService();
    }

    SecurityClassification getSecurityTagBySchemaElementId(String serverName, String userId, String schemaElementId) throws PropertyServerException, RepositoryErrorException, UserNotAuthorizedException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException {
        OMRSMetadataCollection metadataCollection = this.getRepositoryConnector(serverName).getMetadataCollection();
        EntityDetail entityDetail = metadataCollection.getEntityDetail(userId, schemaElementId);
        List classifications = entityDetail.getClassifications();
        return this.getSecurityClassification(serverName, classifications);
    }

    List<SecuritySchemaElement> updateSecurityTagBySchemaElementId(String serverName, String userId, String schemaElementId, SecurityClassification securityClassification) throws PropertyServerException, RepositoryErrorException, ClassificationErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, EntityProxyOnlyException, TypeDefNotKnownException, TypeErrorException, PagingErrorException {
        OMRSMetadataCollection metadataCollection = this.getRepositoryConnector(serverName).getMetadataCollection();
        InstanceProperties instanceProperties = this.getInstanceProperties(serverName, securityClassification);
        EntityDetail schemaElement = metadataCollection.getEntityDetail(userId, schemaElementId);
        SecuritySchemaElement securitySchemaElement = this.updateSecurityTagsClassificationForEntity(serverName, userId, metadataCollection, instanceProperties, schemaElement);
        ArrayList<SecuritySchemaElement> result = new ArrayList<SecuritySchemaElement>();
        result.add(securitySchemaElement);
        this.updateSecurityTagOnColumns(serverName, userId, metadataCollection, instanceProperties, schemaElement, result, securityClassification.getSecurityLabels());
        return result;
    }

    List<SecuritySchemaElement> deleteSecurityTagBySchemaElementId(String serverName, String userId, String schemaElementId) throws PropertyServerException, RepositoryErrorException, UserNotAuthorizedException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException, ClassificationErrorException, TypeErrorException, TypeDefNotKnownException, PagingErrorException, FunctionNotSupportedException, PropertyErrorException {
        OMRSMetadataCollection metadataCollection = this.getRepositoryConnector(serverName).getMetadataCollection();
        EntityDetail entityDetail = metadataCollection.getEntityDetail(userId, schemaElementId);
        OMRSRepositoryHelper repositoryHelper = this.getRepositoryConnector(serverName).getRepositoryHelper();
        EntityDetail response = this.deleteSecurityTagClassification(repositoryHelper, serverName, entityDetail);
        List<EntityDetail> deleteSecurityTagOnColumns = this.deleteSecurityTagOnColumns(serverName, entityDetail, userId, metadataCollection);
        if (deleteSecurityTagOnColumns != null) {
            deleteSecurityTagOnColumns.add(response);
            return this.builder.buildSecuritySchemaElementList(deleteSecurityTagOnColumns, repositoryHelper);
        }
        return this.builder.buildSecuritySchemaElementList(Collections.singletonList(response), repositoryHelper);
    }

    private EntityDetail addSecurityTagsClassification(String userId, OMRSMetadataCollection metadataCollection, InstanceProperties instanceProperties, EntityDetail schemaElement) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        if (schemaElement.getClassifications() != null && !schemaElement.getClassifications().isEmpty()) {
            return metadataCollection.updateEntityClassification(userId, schemaElement.getGUID(), "SecurityTags", instanceProperties);
        }
        return metadataCollection.classifyEntity(userId, schemaElement.getGUID(), "SecurityTags", instanceProperties);
    }

    private EntityDetail deleteSecurityTagClassification(OMRSRepositoryHelper repositoryHelper, String serverName, EntityDetail entityDetail) throws ClassificationErrorException {
        return repositoryHelper.deleteClassificationFromEntity(serverName, entityDetail, "SecurityTags", "deleteSecurityTagClassification");
    }

    private OMRSRepositoryConnector getRepositoryConnector(String serverName) throws PropertyServerException {
        SecurityOfficerServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRepositoryConnector();
        }
        String methodName = "getRepositoryConnector";
        SecurityOfficerErrorCode errorCode = SecurityOfficerErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void updateSecurityTagOnColumns(String serverName, String userId, OMRSMetadataCollection metadataCollection, InstanceProperties instanceProperties, EntityDetail schemaElement, List<SecuritySchemaElement> result, List<String> newSecurityLabels) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, TypeErrorException, PagingErrorException, EntityNotKnownException, FunctionNotSupportedException, PropertyErrorException, ClassificationErrorException, PropertyServerException {
        if (this.isRelationalTable(schemaElement.getType().getTypeDefName())) {
            List<EntityDetail> columns = this.getColumns(metadataCollection, userId, schemaElement);
            for (EntityDetail column : columns) {
                if (!this.isMoreRestrictiveLabel(serverName, column.getClassifications(), newSecurityLabels)) continue;
                SecuritySchemaElement columnUpdated = this.updateSecurityTagsClassificationForEntity(serverName, userId, metadataCollection, instanceProperties, column);
                result.add(columnUpdated);
            }
        }
    }

    private List<EntityDetail> deleteSecurityTagOnColumns(String serverName, EntityDetail schemaElement, String userId, OMRSMetadataCollection metadataCollection) throws InvalidParameterException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, UserNotAuthorizedException, RepositoryErrorException, ClassificationErrorException, PropertyServerException {
        if (!this.isRelationalTable(schemaElement.getType().getTypeDefName())) {
            return Collections.emptyList();
        }
        List<EntityDetail> columns = this.getColumns(metadataCollection, userId, schemaElement);
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityDetail> entitiesWithDeletedSecurityTags = new ArrayList<EntityDetail>();
        OMRSRepositoryHelper repositoryHelper = this.getRepositoryConnector(serverName).getRepositoryHelper();
        for (EntityDetail column : columns) {
            SecurityClassification securityTags = this.getSecurityClassification(serverName, column.getClassifications());
            if (securityTags == null) continue;
            if (this.isEligibleForDelete(securityTags, column.getType().getTypeDefName()).booleanValue()) {
                this.deleteSecurityTagClassification(repositoryHelper, serverName, column);
                entitiesWithDeletedSecurityTags.add(column);
                continue;
            }
            log.debug("The security tag on the schema element should not be deleted because the source of the assignment is different.");
        }
        return entitiesWithDeletedSecurityTags;
    }

    private boolean isMoreRestrictiveLabel(String serverName, List<Classification> classifications, List<String> newSecurityLabels) throws PropertyServerException {
        SecurityClassification securityClassification = this.getSecurityClassification(serverName, classifications);
        if (securityClassification == null) {
            return true;
        }
        List existingSecurityLabels = securityClassification.getSecurityLabels();
        Optional<String> existingConfidentialityLevel = this.getConfidentialityLabel(existingSecurityLabels);
        if (!existingConfidentialityLevel.isPresent()) {
            return true;
        }
        Optional<String> newConfidentialityLabel = this.getConfidentialityLabel(newSecurityLabels);
        if (!newConfidentialityLabel.isPresent()) {
            return true;
        }
        Integer currentConfidentialityLevel = this.getConfidentialityLevel(existingConfidentialityLevel.get());
        Integer newConfidentialityLevel = this.getConfidentialityLevel(newConfidentialityLabel.get());
        return currentConfidentialityLevel < newConfidentialityLevel;
    }

    private Boolean isEligibleForDelete(SecurityClassification securityTag, String actualSource) {
        String source;
        if (securityTag.getSecurityProperties() != null && actualSource.equals(source = String.valueOf(securityTag.getSecurityProperties().get("source")))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Optional<String> getConfidentialityLabel(List<String> securityLabels) {
        return securityLabels.stream().filter(l -> l.startsWith("C")).findAny();
    }

    private Integer getConfidentialityLevel(String confidentialityLabel) {
        return Integer.valueOf(confidentialityLabel.substring(1));
    }

    private List<EntityDetail> getColumns(OMRSMetadataCollection metadataCollection, String userId, EntityDetail schemaElement) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, TypeErrorException, PagingErrorException, EntityNotKnownException, FunctionNotSupportedException, PropertyErrorException {
        List<Relationship> tableTypeRelationship = this.getRelationshipsByType(metadataCollection, userId, schemaElement.getGUID(), "SchemaAttributeType");
        if (tableTypeRelationship != null && tableTypeRelationship.size() == 1) {
            EntityDetail tableType = this.getEntity(userId, metadataCollection, schemaElement.getGUID(), tableTypeRelationship.get(0));
            if (tableType == null) {
                return Collections.emptyList();
            }
            List<Relationship> columnsRelationships = this.getRelationshipsByType(metadataCollection, userId, tableType.getGUID(), "AttributeForSchema");
            return columnsRelationships.stream().map(columnsRelationship -> this.getEntity(userId, metadataCollection, tableType.getGUID(), (Relationship)columnsRelationship)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<Relationship> getRelationshipsByType(OMRSMetadataCollection metadataCollection, String userId, String entityGUID, String type) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, EntityNotKnownException, FunctionNotSupportedException, PropertyErrorException, TypeErrorException, PagingErrorException {
        String schemaAttributeTypeGuid = this.getTypeGUID(metadataCollection, userId, type);
        return this.getRelationships(userId, metadataCollection, schemaAttributeTypeGuid, entityGUID);
    }

    private EntityDetail getEntity(String userId, OMRSMetadataCollection metadataCollection, String knownId, Relationship relationship) {
        String entityGUID = relationship.getEntityTwoProxy().getGUID().equals(knownId) ? relationship.getEntityOneProxy().getGUID() : relationship.getEntityTwoProxy().getGUID();
        try {
            return metadataCollection.getEntityDetail(userId, entityGUID);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            log.debug("Unable to get the entity by guid {}", (Object)entityGUID);
            return null;
        }
    }

    private List<Relationship> getRelationships(String userId, OMRSMetadataCollection metadataCollection, String relationshipTypeGUID, String entityGuid) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        return metadataCollection.getRelationshipsForEntity(userId, entityGuid, relationshipTypeGUID, 0, null, null, null, null, 0);
    }

    private boolean isRelationalTable(String typeDefName) {
        return typeDefName.equals("RelationalTable");
    }

    private boolean isSecurityTag(String name) {
        return "SecurityTags".equals(name);
    }

    private SecuritySchemaElement updateSecurityTagsClassificationForEntity(String serverName, String userId, OMRSMetadataCollection metadataCollection, InstanceProperties instanceProperties, EntityDetail schemaElement) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException, PropertyServerException {
        EntityDetail entityDetail = this.addSecurityTagsClassification(userId, metadataCollection, instanceProperties, schemaElement);
        OMRSRepositoryHelper omrsRepositoryHelper = this.getRepositoryConnector(serverName).getRepositoryHelper();
        SecuritySchemaElement schemaElementEntity = this.builder.buildSecuritySchemaElement(entityDetail, omrsRepositoryHelper);
        this.publishEventForUpdatedSecurityTags(serverName, schemaElement, schemaElementEntity);
        return schemaElementEntity;
    }

    private void publishEventForUpdatedSecurityTags(String serverName, EntityDetail schemaElement, SecuritySchemaElement schemaElementEntity) throws PropertyServerException {
        SecurityOfficerUpdateTagEvent event = this.buildEventForUpdatedSecurityTags(serverName, schemaElement, schemaElementEntity);
        SecurityOfficerServicesInstance instance = instanceMap.getInstance(serverName);
        try {
            instance.getSecurityOfficerPublisher().sendEvent((SecurityOfficerEvent)event);
        }
        catch (JsonProcessingException e) {
            log.debug("Unable to send event for updated security tags");
        }
    }

    List<SecurityClassification> getAvailableSecurityTags(String serverName, String userId) throws PropertyServerException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, UserNotAuthorizedException, TypeErrorException, FunctionNotSupportedException, ClassificationErrorException, PagingErrorException, PropertyErrorException {
        OMRSMetadataCollection metadataCollection = this.getRepositoryConnector(serverName).getMetadataCollection();
        String entityTypeGuid = this.getTypeGUID(metadataCollection, userId, "SchemaElement");
        if (entityTypeGuid == null) {
            return Collections.emptyList();
        }
        List<EntityDetail> entitiesWithSecurityTagsAssigned = this.findEntitiesWithSecurityTagsAssigned(userId, metadataCollection, entityTypeGuid);
        if (entitiesWithSecurityTagsAssigned == null || entitiesWithSecurityTagsAssigned.isEmpty()) {
            return Collections.emptyList();
        }
        OMRSRepositoryHelper omrsRepositoryHelper = this.getRepositoryConnector(serverName).getRepositoryHelper();
        return entitiesWithSecurityTagsAssigned.stream().flatMap(entityDetail -> entityDetail.getClassifications().stream()).filter(classification -> this.isSecurityTag(classification.getName())).map(classification -> this.builder.buildSecurityTag((Classification)classification, omrsRepositoryHelper)).distinct().collect(Collectors.toList());
    }

    private List<EntityDetail> findEntitiesWithSecurityTagsAssigned(String userId, OMRSMetadataCollection metadataCollection, String entityTypeGuid) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        return metadataCollection.findEntitiesByClassification(userId, entityTypeGuid, "SecurityTags", null, null, 0, null, null, null, null, 0);
    }

    private String getTypeGUID(OMRSMetadataCollection metadataCollection, String userId, String typeName) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException {
        TypeDef typeDefByName = metadataCollection.getTypeDefByName(userId, typeName);
        if (typeDefByName != null) {
            return typeDefByName.getGUID();
        }
        return null;
    }

    private SecurityClassification getSecurityClassification(String serverName, List<Classification> classifications) throws PropertyServerException {
        if (classifications == null || classifications.isEmpty()) {
            return null;
        }
        Optional<Classification> securityTag = classifications.stream().filter(classification -> classification.getName().equals("SecurityTags")).findAny();
        OMRSRepositoryHelper repositoryHelper = this.getRepositoryConnector(serverName).getRepositoryHelper();
        return securityTag.map(classification -> this.builder.buildSecurityTag((Classification)classification, repositoryHelper)).orElse(null);
    }

    private SecurityOfficerUpdateTagEvent buildEventForUpdatedSecurityTags(String serverName, EntityDetail schemaElement, SecuritySchemaElement result) throws PropertyServerException {
        SecurityOfficerUpdateTagEvent event = new SecurityOfficerUpdateTagEvent();
        event.setSecuritySchemaElement(result);
        event.setPreviousClassification(this.getSecurityClassification(serverName, schemaElement.getClassifications()));
        event.setEventType(SecurityOfficerEventType.UPDATED_SECURITY_ASSIGNMENT);
        return event;
    }

    private InstanceProperties getInstanceProperties(String serverName, SecurityClassification securityTagLevel) throws PropertyServerException {
        InstanceProperties instanceProperties = new InstanceProperties();
        String methodName = "getInstanceProperties";
        OMRSRepositoryHelper repositoryHelper = this.getRepositoryConnector(serverName).getRepositoryHelper();
        repositoryHelper.addMapPropertyToInstance("SecurityOfficerOMAS", instanceProperties, "securityProperties", securityTagLevel.getSecurityProperties(), methodName);
        repositoryHelper.addStringArrayPropertyToInstance("SecurityOfficerOMAS", instanceProperties, "securityLabels", securityTagLevel.getSecurityLabels(), methodName);
        return instanceProperties;
    }
}

