/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.admin.services;

import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.errorcode.SecurityOfficerErrorCode;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.publisher.SecurityOfficerPublisher;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.services.SecurityOfficerServicesInstanceMap;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SecurityOfficerServicesInstance {
    private OMRSRepositoryConnector repositoryConnector;
    private OMRSMetadataCollection metadataCollection;
    private SecurityOfficerPublisher securityOfficerPublisher;
    private String serverName;

    public SecurityOfficerServicesInstance(OMRSRepositoryConnector repositoryConnector, SecurityOfficerPublisher securityOfficerPublisher) throws NewInstanceException {
        String methodName = "new ServiceInstance";
        if (securityOfficerPublisher != null) {
            this.securityOfficerPublisher = securityOfficerPublisher;
        }
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.serverName = repositoryConnector.getServerName();
                this.metadataCollection = repositoryConnector.getMetadataCollection();
                SecurityOfficerServicesInstanceMap.setNewInstanceForJVM(this.serverName, this);
            }
            catch (Exception error) {
                SecurityOfficerErrorCode errorCode = SecurityOfficerErrorCode.OMRS_NOT_INITIALIZED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
                throw new NewInstanceException(errorCode.getHttpErrorCode(), this.getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            SecurityOfficerErrorCode errorCode = SecurityOfficerErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHttpErrorCode(), this.getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        SecurityOfficerErrorCode errorCode = SecurityOfficerErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getServerName"});
        throw new NewInstanceException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getServerName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    OMRSRepositoryConnector getRepositoryConnector() throws PropertyServerException {
        String methodName = "getRepositoryConnector";
        if (this.repositoryConnector != null && this.metadataCollection != null && this.repositoryConnector.isActive()) {
            return this.repositoryConnector;
        }
        SecurityOfficerErrorCode errorCode = SecurityOfficerErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    SecurityOfficerPublisher getSecurityOfficerPublisher() {
        return this.securityOfficerPublisher;
    }

    public void shutdown() {
        SecurityOfficerServicesInstanceMap.removeInstanceForJVM(this.serverName);
    }
}

