/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.admin.services;

import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.exceptions.SecurityOfficerException;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecurityClassification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerOMASAPIResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerSchemaElementListResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerSecurityTagListResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerSecurityTagResponse;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.services.SecurityOfficerInstanceHandler;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.utils.ExceptionHandler;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class SecurityOfficerService {
    private static SecurityOfficerInstanceHandler instanceHandler = new SecurityOfficerInstanceHandler();
    private ExceptionHandler exceptionHandler = new ExceptionHandler();

    public SecurityOfficerSecurityTagResponse getSecurityTagBySchemaElementId(String serverName, String userId, String schemaElementId) {
        SecurityOfficerSecurityTagResponse response = new SecurityOfficerSecurityTagResponse();
        try {
            response.setSecurityTag(instanceHandler.getSecurityTagBySchemaElementId(serverName, userId, schemaElementId));
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSException((SecurityOfficerOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException e) {
            this.exceptionHandler.captureCheckedException((SecurityOfficerOMASAPIResponse)response, (SecurityOfficerException)e, ((Object)((Object)e)).getClass().getName());
        }
        return response;
    }

    public SecurityOfficerSecurityTagListResponse getSecurityTags(String serverName, String userId) {
        SecurityOfficerSecurityTagListResponse response = new SecurityOfficerSecurityTagListResponse();
        try {
            response.setSecurityTags(instanceHandler.getAvailableSecurityTags(serverName, userId));
        }
        catch (ClassificationErrorException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSException((SecurityOfficerOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException e) {
            this.exceptionHandler.captureCheckedException((SecurityOfficerOMASAPIResponse)response, (SecurityOfficerException)e, ((Object)((Object)e)).getClass().getName());
        }
        return response;
    }

    public SecurityOfficerSchemaElementListResponse updateSecurityTag(String serverName, String userId, String schemaElementId, SecurityClassification securityClassification) {
        SecurityOfficerSchemaElementListResponse response = new SecurityOfficerSchemaElementListResponse();
        try {
            response.setSchemaElementEntityList(instanceHandler.updateSecurityTagBySchemaElementId(serverName, userId, schemaElementId, securityClassification));
        }
        catch (ClassificationErrorException | EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSException((SecurityOfficerOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException e) {
            this.exceptionHandler.captureCheckedException((SecurityOfficerOMASAPIResponse)response, (SecurityOfficerException)e, ((Object)((Object)e)).getClass().getName());
        }
        return response;
    }

    public SecurityOfficerSchemaElementListResponse deleteSecurityTag(String serverName, String userId, String schemaElementId) {
        SecurityOfficerSchemaElementListResponse response = new SecurityOfficerSchemaElementListResponse();
        try {
            response.setSchemaElementEntityList(instanceHandler.deleteSecurityTagBySchemaElementId(serverName, userId, schemaElementId));
        }
        catch (ClassificationErrorException | EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSException((SecurityOfficerOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException e) {
            this.exceptionHandler.captureCheckedException((SecurityOfficerOMASAPIResponse)response, (SecurityOfficerException)e, ((Object)((Object)e)).getClass().getName());
        }
        return response;
    }
}

