/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.services;

import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecurityClassification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerSchemaElementListResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerSecurityTagListResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerSecurityTagResponse;
import org.odpi.openmetadata.accessservices.securityofficer.server.handler.SecurityOfficerRequestHandler;
import org.odpi.openmetadata.accessservices.securityofficer.server.services.SecurityOfficerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class SecurityOfficerRESTService {
    private static SecurityOfficerInstanceHandler instanceHandler = new SecurityOfficerInstanceHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SecurityOfficerRESTService.class), instanceHandler.getServiceName());

    public SecurityOfficerSecurityTagResponse getSecurityTagBySchemaElementId(String serverName, String userId, String schemaElementId) {
        String methodName = "getSecurityTagBySchemaElementId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSecurityTagBySchemaElementId");
        AuditLog auditLog = null;
        SecurityOfficerSecurityTagResponse response = new SecurityOfficerSecurityTagResponse();
        try {
            SecurityOfficerRequestHandler handler = instanceHandler.getSecurityOfficerRequestHandler(userId, serverName, "getSecurityTagBySchemaElementId");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityTagBySchemaElementId");
            response.setSecurityTag(handler.getSecurityTagBySchemaElementId(userId, schemaElementId, "getSecurityTagBySchemaElementId"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSecurityTagBySchemaElementId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SecurityOfficerSecurityTagListResponse getSecurityTags(String serverName, String userId) {
        String methodName = "getSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSecurityTags");
        AuditLog auditLog = null;
        SecurityOfficerSecurityTagListResponse response = new SecurityOfficerSecurityTagListResponse();
        try {
            SecurityOfficerRequestHandler handler = instanceHandler.getSecurityOfficerRequestHandler(userId, serverName, "getSecurityTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityTags");
            response.setSecurityTags(handler.getAvailableSecurityTags(userId, "getSecurityTags"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SecurityOfficerSchemaElementListResponse updateSecurityTag(String serverName, String userId, String schemaElementId, SecurityClassification securityClassification) {
        String methodName = "updateSecurityTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSecurityTag");
        AuditLog auditLog = null;
        SecurityOfficerSchemaElementListResponse response = new SecurityOfficerSchemaElementListResponse();
        try {
            SecurityOfficerRequestHandler handler = instanceHandler.getSecurityOfficerRequestHandler(userId, serverName, "updateSecurityTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSecurityTag");
            response.setSchemaElementEntityList(handler.updateSecurityTagBySchemaElementId(userId, schemaElementId, securityClassification, "updateSecurityTag"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateSecurityTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SecurityOfficerSchemaElementListResponse deleteSecurityTag(String serverName, String userId, String schemaElementId) {
        String methodName = "deleteSecurityTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteSecurityTag");
        AuditLog auditLog = null;
        SecurityOfficerSchemaElementListResponse response = new SecurityOfficerSchemaElementListResponse();
        try {
            SecurityOfficerRequestHandler handler = instanceHandler.getSecurityOfficerRequestHandler(userId, serverName, "deleteSecurityTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteSecurityTag");
            response.setSchemaElementEntityList(handler.deleteSecurityTagBySchemaElementId(userId, schemaElementId, "deleteSecurityTag"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteSecurityTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

