/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.admin.publisher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerTagEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.errorcode.SecurityOfficerErrorCode;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.processor.SecurityOfficerEventProcessor;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOfficerPublisher
extends OMRSInstanceEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(SecurityOfficerPublisher.class);
    private static final String eventPublisherName = "Security Officer OMAS Event Publisher";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private SecurityOfficerEventProcessor securityOfficerEventProcessor;
    private OpenMetadataTopicConnector openMetadataTopicConnector;
    private OMRSAuditLog auditLog;

    public SecurityOfficerPublisher(SecurityOfficerEventProcessor securityOfficerEventProcessor, OpenMetadataTopicConnector openMetadataTopicConnector, OMRSAuditLog auditLog) {
        super(eventPublisherName);
        this.securityOfficerEventProcessor = securityOfficerEventProcessor;
        this.openMetadataTopicConnector = openMetadataTopicConnector;
        this.auditLog = auditLog;
    }

    public void sendInstanceEvent(String sourceName, OMRSInstanceEvent instanceEvent) {
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        if (this.isGlossaryTerm(entity.getType()) && this.containsGovernanceConfidentialityClassification(entity.getClassifications())) {
            List<SecurityOfficerTagEvent> securityOfficerEvents = this.securityOfficerEventProcessor.processClassifiedGlossaryTerm(entity);
            if (securityOfficerEvents.isEmpty()) {
                return;
            }
            try {
                for (SecurityOfficerTagEvent securityOfficerEvent : securityOfficerEvents) {
                    this.sendEvent((SecurityOfficerEvent)securityOfficerEvent);
                }
            }
            catch (JsonProcessingException e) {
                log.debug("Unable to build the event for classified glossary term.");
            }
        } else {
            log.debug("No processing needed");
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        if (this.isGlossaryTerm(entity.getType()) && this.containsGovernanceConfidentialityClassification(entity.getClassifications())) {
            List<SecurityOfficerTagEvent> securityOfficerEvents = this.securityOfficerEventProcessor.processDeClassifiedGlossaryTerm(entity);
            try {
                for (SecurityOfficerTagEvent securityOfficerEvent : securityOfficerEvents) {
                    this.sendEvent((SecurityOfficerEvent)securityOfficerEvent);
                }
            }
            catch (JsonProcessingException e) {
                log.debug("Unable to build the event for de-classified glossary term.");
            }
        } else {
            log.debug("No processing needed");
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        if (this.isGlossaryTerm(entity.getType()) && this.containsGovernanceConfidentialityClassification(entity.getClassifications())) {
            List<SecurityOfficerTagEvent> securityOfficerEvents = this.securityOfficerEventProcessor.processReClassifiedGlossaryTerm(entity);
            try {
                for (SecurityOfficerTagEvent securityOfficerEvent : securityOfficerEvents) {
                    this.sendEvent((SecurityOfficerEvent)securityOfficerEvent);
                }
            }
            catch (JsonProcessingException e) {
                log.debug("Unable to build the event for re-classified glossary term.");
            }
        } else {
            log.debug("No processing needed");
        }
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDef, EntityDetail entity) {
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
    }

    public void processRefreshEntityRequested(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (relationship.getType().getTypeDefName().equals("SemanticAssignment") && this.isSchemaElement(relationship.getEntityOneProxy().getType())) {
            SecurityOfficerTagEvent securityOfficerEvent = this.securityOfficerEventProcessor.processSemanticAssignmentForSchemaElement(relationship);
            try {
                this.sendEvent((SecurityOfficerEvent)securityOfficerEvent);
            }
            catch (JsonProcessingException e) {
                log.debug("Unable to build the event for semantic assigment between a glossary term and a schema element.");
            }
        } else {
            log.debug("No processing needed");
        }
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDef, Relationship relationship) {
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, Relationship relationship) {
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
    }

    public void processRefreshRelationshipRequest(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
    }

    public void processConflictingInstancesEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDef, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDef, String otherInstanceGUID, String errorMessage) {
    }

    public void processConflictingTypeEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDef, String targetInstanceGUID, TypeDefSummary otherTypeDef, String errorMessage) {
    }

    public void sendEvent(SecurityOfficerEvent securityOfficerEvent) throws JsonProcessingException {
        String event = OBJECT_MAPPER.writeValueAsString((Object)securityOfficerEvent);
        try {
            this.openMetadataTopicConnector.sendEvent(event);
        }
        catch (ConnectorCheckedException e) {
            log.error("Exception publishing event", (Throwable)e);
            SecurityOfficerErrorCode auditCode = SecurityOfficerErrorCode.PUBLISH_EVENT_EXCEPTION;
            this.auditLog.logException("send event", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(new String[]{securityOfficerEvent.getClass().getName(), e.getMessage()}), "event {" + securityOfficerEvent + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
        }
    }

    private boolean isSchemaElement(InstanceType type) {
        if (type != null) {
            return type.getTypeDefSuperTypes().stream().filter(Objects::nonNull).anyMatch(typeDefLink -> "SchemaElement".equals(typeDefLink.getName()));
        }
        return false;
    }

    private boolean isGlossaryTerm(InstanceType type) {
        return "GlossaryTerm".equals(type.getTypeDefName());
    }

    private boolean containsGovernanceConfidentialityClassification(List<Classification> classifications) {
        if (classifications != null) {
            return classifications.stream().map(this::getClassificationName).filter(Objects::nonNull).anyMatch("Confidentiality"::equals);
        }
        return false;
    }

    private String getClassificationName(Classification classification) {
        InstanceType type = classification.getType();
        if (type != null) {
            return type.getTypeDefName();
        }
        return classification.getName();
    }
}

