/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.SecurityOfficerAuditCode;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.SecurityOfficerErrorCode;
import org.odpi.openmetadata.accessservices.securityofficer.server.listener.SecurityOfficerOMRSTopicListener;
import org.odpi.openmetadata.accessservices.securityofficer.server.processors.SecurityOfficerEventProcessor;
import org.odpi.openmetadata.accessservices.securityofficer.server.publisher.SecurityOfficerPublisher;
import org.odpi.openmetadata.accessservices.securityofficer.server.services.SecurityOfficerInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;

public class SecurityOfficerAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog;
    private String serverName;
    private SecurityOfficerInstance instance;
    private SecurityOfficerPublisher securityOfficerPublisher;

    public synchronized void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", SecurityOfficerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            this.auditLog = auditLog;
            List supportedZones = super.extractSupportedZones(accessServiceConfigurationProperties.getAccessServiceOptions(), accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
            OpenMetadataTopicConnector securityOfficerOutputTopic = this.initializeSecurityOfficerTopicConnector(accessServiceConfigurationProperties.getAccessServiceOutTopic());
            SecurityOfficerEventProcessor securityOfficerEventProcessor = new SecurityOfficerEventProcessor(enterpriseOMRSRepositoryConnector);
            this.securityOfficerPublisher = new SecurityOfficerPublisher(securityOfficerEventProcessor, securityOfficerOutputTopic, auditLog);
            this.instance = new SecurityOfficerInstance(enterpriseOMRSRepositoryConnector, supportedZones, auditLog, serverUserName, enterpriseOMRSRepositoryConnector.getMaxPageSize(), accessServiceConfigurationProperties.getAccessServiceOutTopic(), this.securityOfficerPublisher);
            this.serverName = this.instance.getServerName();
            this.registerWithEnterpriseTopic(AccessServiceDescription.SECURITY_OFFICER_OMAS.getAccessServiceFullName(), this.serverName, enterpriseOMRSTopicConnector, (OMRSTopicListener)new SecurityOfficerOMRSTopicListener(this.securityOfficerPublisher, enterpriseOMRSRepositoryConnector.getRepositoryHelper(), enterpriseOMRSRepositoryConnector.getRepositoryValidator(), AccessServiceDescription.SECURITY_OFFICER_OMAS.getAccessServiceFullName(), this.serverName, serverUserName, supportedZones, auditLog), auditLog);
            auditLog.logMessage("initialize", SecurityOfficerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}));
        }
        catch (OMAGConfigurationErrorException error) {
            auditLog.logException("initialize", SecurityOfficerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfigurationProperties.toString(), (Throwable)error);
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", SecurityOfficerAuditCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new OMAGConfigurationErrorException(SecurityOfficerErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), AccessServiceDescription.SECURITY_OFFICER_OMAS.getAccessServiceFullName(), this.serverName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", (Throwable)error);
        }
    }

    private OpenMetadataTopicConnector initializeSecurityOfficerTopicConnector(Connection topicConnection) {
        String actionDescription = "initialize";
        if (topicConnection != null) {
            try {
                return this.getTopicConnector(topicConnection);
            }
            catch (Exception e) {
                this.auditLog.logException("initialize", SecurityOfficerAuditCode.ERROR_INITIALIZING_TOPIC_CONNECTION.getMessageDefinition(new String[]{topicConnection.toString(), this.serverName, e.getMessage()}), (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(topicConnection);
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connector;
            topicConnector.setAuditLog(this.auditLog);
            topicConnector.start();
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            throw new OMRSConfigErrorException(SecurityOfficerErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(new String[]{"getTopicConnector"}), ((Object)((Object)this)).getClass().getName(), "getTopicConnector", (Throwable)error);
        }
    }

    public synchronized void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.securityOfficerPublisher != null) {
            this.securityOfficerPublisher.disconnect();
        }
        this.auditLog.logMessage("shutdown", SecurityOfficerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

