/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.SecurityOfficerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOfficerHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityOfficerHandler.class);
    private OMRSMetadataCollection metadataCollection;

    public SecurityOfficerHandler(OMRSRepositoryConnector repositoryConnector) throws PropertyServerException {
        String methodName = "SecurityOfficerHandler";
        if (repositoryConnector != null) {
            try {
                this.metadataCollection = repositoryConnector.getMetadataCollection();
            }
            catch (RepositoryErrorException e) {
                throw new PropertyServerException(SecurityOfficerErrorCode.NO_METADATA_COLLECTION.getMessageDefinition(new String[]{repositoryConnector.getRepositoryName()}), this.getClass().getName(), "SecurityOfficerHandler", (Throwable)e);
            }
        }
    }

    public EntityDetail getEntityDetailById(String userId, String assetGuid) {
        try {
            return this.metadataCollection.getEntityDetail(userId, assetGuid);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            log.debug("Unable to retrieve the entity with guid = {}", (Object)assetGuid);
            return null;
        }
    }

    public List<EntityDetail> getSchemaElementsAssignedToBusinessTerms(String userId, String glossaryTermGUID) {
        List<Relationship> relationships = this.getSemanticAssigmentRelationships(userId, glossaryTermGUID);
        ArrayList<EntityDetail> schemaElements = new ArrayList<EntityDetail>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityDetail schemaElement = this.getSchemaElement(userId, glossaryTermGUID, relationship);
                if (schemaElement == null) continue;
                schemaElements.add(schemaElement);
            }
        }
        return schemaElements;
    }

    private List<Relationship> getSemanticAssigmentRelationships(String userId, String glossaryTermGUID) {
        try {
            return this.metadataCollection.getRelationshipsForEntity(userId, glossaryTermGUID, "e6670973-645f-441a-bec7-6f5570345b92", 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, SequencingOrder.ANY, 0);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            log.debug("Unable to fetch semantic assignments for {}", (Object)glossaryTermGUID);
            return Collections.emptyList();
        }
    }

    private EntityDetail getSchemaElement(String userId, String glossaryTermGUID, Relationship relationship) {
        try {
            if (relationship.getEntityOneProxy().getGUID().equals(glossaryTermGUID)) {
                if (this.isSchemaElement(relationship.getEntityTwoProxy().getType())) {
                    return this.metadataCollection.getEntityDetail(userId, relationship.getEntityTwoProxy().getGUID());
                }
            } else if (this.isSchemaElement(relationship.getEntityOneProxy().getType())) {
                return this.metadataCollection.getEntityDetail(userId, relationship.getEntityOneProxy().getGUID());
            }
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException | UserNotAuthorizedException e) {
            log.debug("Unable to get schema element entity");
        }
        return null;
    }

    private boolean isSchemaElement(InstanceType instanceType) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException {
        List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
        if (typeDefSuperTypes.stream().anyMatch(typeDefLink -> typeDefLink.getName().equals("SchemaAttribute"))) {
            return true;
        }
        for (TypeDefLink typeDefLink2 : typeDefSuperTypes) {
            if (!this.metadataCollection.getTypeDefByName("SecurityOfficerOMAS", typeDefLink2.getName()).getSuperType().getName().equals("SchemaAttribute")) continue;
            return true;
        }
        return false;
    }
}

