/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.services;

import java.util.List;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.SecurityOfficerErrorCode;
import org.odpi.openmetadata.accessservices.securityofficer.connectors.outtopic.SecurityOfficerOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.securityofficer.server.handler.GovernedAssetHandler;
import org.odpi.openmetadata.accessservices.securityofficer.server.handler.SecurityOfficerRequestHandler;
import org.odpi.openmetadata.accessservices.securityofficer.server.publisher.SecurityOfficerPublisher;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SecurityOfficerInstance
extends OMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.SECURITY_OFFICER_OMAS;
    private SecurityOfficerRequestHandler securityOfficerRequestHandler;
    private GovernedAssetHandler governedAssetHandler;

    public SecurityOfficerInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection outTopicEventBusConnection, SecurityOfficerPublisher securityOfficerPublisher) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, null, null, auditLog, localServerUserId, maxPageSize, null, null, SecurityOfficerOutTopicClientProvider.class.getName(), outTopicEventBusConnection);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(SecurityOfficerErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.securityOfficerRequestHandler = new SecurityOfficerRequestHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.metadataCollection, this.repositoryHelper, this.errorHandler, supportedZones, securityOfficerPublisher);
        this.governedAssetHandler = new GovernedAssetHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.errorHandler, supportedZones);
    }

    public GovernedAssetHandler getGovernedAssetHandler() {
        return this.governedAssetHandler;
    }

    public SecurityOfficerRequestHandler getSecurityOfficerRequestHandler() {
        return this.securityOfficerRequestHandler;
    }
}

