/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.services;

import java.util.List;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.GovernedAssetListResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.GovernedAssetResponse;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SoftwareServerCapabilityRequestBody;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SoftwareServerCapabilityResponse;
import org.odpi.openmetadata.accessservices.securityofficer.server.handler.GovernedAssetHandler;
import org.odpi.openmetadata.accessservices.securityofficer.server.services.SecurityOfficerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernedAssetRESTServices {
    private static SecurityOfficerInstanceHandler instanceHandler = new SecurityOfficerInstanceHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GovernedAssetListResponse getGovernedAssets(String serverName, String userId, List<String> entityTypes, Integer offset, Integer pageSize) {
        String methodName = "getGovernedAssets";
        GovernedAssetListResponse response = new GovernedAssetListResponse();
        AuditLog auditLog = null;
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(userId, serverName, methodName);
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            response.setGovernedAssetList(governedAssetHandler.getGovernedAssets(userId, entityTypes, offset, pageSize));
        }
        catch (Exception e) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, e, methodName, auditLog);
        }
        return response;
    }

    public GovernedAssetResponse getGovernedAsset(String serverName, String userId, String assetGuid) {
        String methodName = "getGovernedAsset";
        GovernedAssetResponse response = new GovernedAssetResponse();
        AuditLog auditLog = null;
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(userId, serverName, methodName);
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            response.setAsset(governedAssetHandler.getGovernedAsset(userId, assetGuid));
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (Exception e) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, e, methodName, auditLog);
        }
        return response;
    }

    public StringResponse createSoftwareServer(String serverName, String userId, SoftwareServerCapabilityRequestBody requestBody) {
        String methodName = "createSoftwareServer";
        StringResponse response = new StringResponse();
        AuditLog auditLog = null;
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(userId, serverName, methodName);
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            response.setResultString(governedAssetHandler.createSoftwareServerCapability(userId, requestBody.getSoftwareServerCapability()));
        }
        catch (Exception e) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, e, methodName, auditLog);
        }
        return response;
    }

    public SoftwareServerCapabilityResponse getSoftwareServerByGUID(String serverName, String userId, String guid) {
        String methodName = "getSoftwareServerByGUID";
        SoftwareServerCapabilityResponse response = new SoftwareServerCapabilityResponse();
        AuditLog auditLog = null;
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(userId, serverName, methodName);
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            response.setServerCapability(governedAssetHandler.getSoftwareServerCapabilityByGUID(userId, guid));
        }
        catch (Exception e) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, e, methodName, auditLog);
        }
        return response;
    }
}

