/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerEventType;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerUpdateTagEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.SecurityOfficerErrorCode;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecurityClassification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecuritySchemaElement;
import org.odpi.openmetadata.accessservices.securityofficer.server.publisher.SecurityOfficerPublisher;
import org.odpi.openmetadata.accessservices.securityofficer.server.utils.Builder;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOfficerRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityOfficerRequestHandler.class);
    private Builder builder = new Builder();
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSMetadataCollection metadataCollection;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private RepositoryErrorHandler errorHandler;
    private OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
    private List<String> supportedZones;
    private SecurityOfficerPublisher securityOfficerPublisher;

    public SecurityOfficerRequestHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSMetadataCollection metadataCollection, OMRSRepositoryHelper repositoryHelper, RepositoryErrorHandler errorHandler, List<String> supportedZones, SecurityOfficerPublisher securityOfficerPublisher) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.metadataCollection = metadataCollection;
        this.repositoryHandler = repositoryHandler;
        this.errorHandler = errorHandler;
        this.supportedZones = supportedZones;
        this.securityOfficerPublisher = securityOfficerPublisher;
    }

    public SecurityClassification getSecurityTagBySchemaElementId(String userId, String schemaElementId, String methodName) throws PropertyServerException {
        try {
            EntityDetail entityDetail = this.metadataCollection.getEntityDetail(userId, schemaElementId);
            List classifications = entityDetail.getClassifications();
            return this.getSecurityClassification(classifications);
        }
        catch (Exception e) {
            throw new PropertyServerException(SecurityOfficerErrorCode.UNEXPECTED_REPOSITORY_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, this.serviceName, this.serverName, e.getMessage()}), this.getClass().getName(), methodName, (Throwable)e);
        }
    }

    public List<SecuritySchemaElement> updateSecurityTagBySchemaElementId(String userId, String schemaElementId, SecurityClassification securityClassification, String methodName) throws PropertyServerException, RepositoryErrorException, ClassificationErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, EntityProxyOnlyException, TypeDefNotKnownException, TypeErrorException, PagingErrorException {
        try {
            InstanceProperties instanceProperties = this.getInstanceProperties(securityClassification);
            EntityDetail schemaElement = this.metadataCollection.getEntityDetail(userId, schemaElementId);
            SecuritySchemaElement securitySchemaElement = this.updateSecurityTagsClassificationForEntity(userId, instanceProperties, schemaElement, methodName);
            ArrayList<SecuritySchemaElement> result = new ArrayList<SecuritySchemaElement>();
            result.add(securitySchemaElement);
            this.updateSecurityTagOnColumns(userId, instanceProperties, schemaElement, result, securityClassification.getSecurityLabels(), methodName);
            return result;
        }
        catch (Exception e) {
            throw new PropertyServerException(SecurityOfficerErrorCode.UNEXPECTED_REPOSITORY_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, this.serviceName, this.serverName, e.getMessage()}), this.getClass().getName(), methodName, (Throwable)e);
        }
    }

    public List<SecuritySchemaElement> deleteSecurityTagBySchemaElementId(String userId, String schemaElementId, String methodName) throws PropertyServerException, RepositoryErrorException, UserNotAuthorizedException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException, ClassificationErrorException, TypeErrorException, TypeDefNotKnownException, PagingErrorException, FunctionNotSupportedException, PropertyErrorException {
        try {
            EntityDetail entityDetail = this.metadataCollection.getEntityDetail(userId, schemaElementId);
            EntityDetail response = this.deleteSecurityTagClassification(this.repositoryHelper, this.serverName, entityDetail, methodName);
            List<EntityDetail> deleteSecurityTagOnColumns = this.deleteSecurityTagOnColumns(entityDetail, userId, methodName);
            if (deleteSecurityTagOnColumns != null) {
                deleteSecurityTagOnColumns.add(response);
                return this.builder.buildSecuritySchemaElementList(deleteSecurityTagOnColumns, this.repositoryHelper);
            }
            return this.builder.buildSecuritySchemaElementList(Collections.singletonList(response), this.repositoryHelper);
        }
        catch (Exception e) {
            throw new PropertyServerException(SecurityOfficerErrorCode.UNEXPECTED_REPOSITORY_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, this.serviceName, this.serverName, e.getMessage()}), this.getClass().getName(), methodName, (Throwable)e);
        }
    }

    private EntityDetail addSecurityTagsClassification(String userId, InstanceProperties instanceProperties, EntityDetail schemaElement, String methodName) throws PropertyServerException {
        try {
            if (schemaElement.getClassifications() != null && !schemaElement.getClassifications().isEmpty()) {
                return this.metadataCollection.updateEntityClassification(userId, schemaElement.getGUID(), "SecurityTags", instanceProperties);
            }
            return this.metadataCollection.classifyEntity(userId, schemaElement.getGUID(), "SecurityTags", instanceProperties);
        }
        catch (Exception e) {
            throw new PropertyServerException(SecurityOfficerErrorCode.UNEXPECTED_REPOSITORY_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, this.serviceName, this.serverName, e.getMessage()}), this.getClass().getName(), methodName, (Throwable)e);
        }
    }

    private EntityDetail deleteSecurityTagClassification(OMRSRepositoryHelper repositoryHelper, String serverName, EntityDetail entityDetail, String methodName) throws ClassificationErrorException {
        return repositoryHelper.deleteClassificationFromEntity(serverName, entityDetail, "SecurityTags", "deleteSecurityTagClassification");
    }

    private void updateSecurityTagOnColumns(String userId, InstanceProperties instanceProperties, EntityDetail schemaElement, List<SecuritySchemaElement> result, List<String> newSecurityLabels, String methodName) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, TypeErrorException, PagingErrorException, EntityNotKnownException, FunctionNotSupportedException, PropertyErrorException, ClassificationErrorException, PropertyServerException {
        if (this.isRelationalTable(schemaElement.getType().getTypeDefName())) {
            List<EntityDetail> columns = this.getColumns(userId, schemaElement, methodName);
            for (EntityDetail column : columns) {
                if (!this.isMoreRestrictiveLabel(column.getClassifications(), newSecurityLabels)) continue;
                SecuritySchemaElement columnUpdated = this.updateSecurityTagsClassificationForEntity(userId, instanceProperties, column, methodName);
                result.add(columnUpdated);
            }
        }
    }

    private List<EntityDetail> deleteSecurityTagOnColumns(EntityDetail schemaElement, String userId, String methodName) throws PropertyServerException {
        if (!this.isRelationalTable(schemaElement.getType().getTypeDefName())) {
            return Collections.emptyList();
        }
        List<EntityDetail> columns = this.getColumns(userId, schemaElement, methodName);
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityDetail> entitiesWithDeletedSecurityTags = new ArrayList<EntityDetail>();
        for (EntityDetail column : columns) {
            SecurityClassification securityTags = this.getSecurityClassification(column.getClassifications());
            if (securityTags == null) continue;
            if (this.isEligibleForDelete(securityTags, column.getType().getTypeDefName()).booleanValue()) {
                try {
                    this.deleteSecurityTagClassification(this.repositoryHelper, this.serverName, column, methodName);
                }
                catch (Exception e) {
                    throw new PropertyServerException(SecurityOfficerErrorCode.UNEXPECTED_REPOSITORY_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, this.serviceName, this.serverName, e.getMessage()}), this.getClass().getName(), methodName, (Throwable)e);
                }
                entitiesWithDeletedSecurityTags.add(column);
                continue;
            }
            log.debug("The security tag on the schema element should not be deleted because the source of the assignment is different.");
        }
        return entitiesWithDeletedSecurityTags;
    }

    private boolean isMoreRestrictiveLabel(List<Classification> classifications, List<String> newSecurityLabels) throws PropertyServerException {
        SecurityClassification securityClassification = this.getSecurityClassification(classifications);
        if (securityClassification == null) {
            return true;
        }
        List existingSecurityLabels = securityClassification.getSecurityLabels();
        Optional<String> existingConfidentialityLevel = this.getConfidentialityLabel(existingSecurityLabels);
        if (!existingConfidentialityLevel.isPresent()) {
            return true;
        }
        Optional<String> newConfidentialityLabel = this.getConfidentialityLabel(newSecurityLabels);
        if (!newConfidentialityLabel.isPresent()) {
            return true;
        }
        Integer currentConfidentialityLevel = this.getConfidentialityLevel(existingConfidentialityLevel.get());
        Integer newConfidentialityLevel = this.getConfidentialityLevel(newConfidentialityLabel.get());
        return currentConfidentialityLevel < newConfidentialityLevel;
    }

    private Boolean isEligibleForDelete(SecurityClassification securityTag, String actualSource) {
        String source;
        if (securityTag.getSecurityProperties() != null && actualSource.equals(source = String.valueOf(securityTag.getSecurityProperties().get("source")))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Optional<String> getConfidentialityLabel(List<String> securityLabels) {
        return securityLabels.stream().filter(l -> l.startsWith("C")).findAny();
    }

    private Integer getConfidentialityLevel(String confidentialityLabel) {
        return Integer.valueOf(confidentialityLabel.substring(1));
    }

    private List<EntityDetail> getColumns(String userId, EntityDetail schemaElement, String methodName) throws PropertyServerException {
        List<Relationship> tableTypeRelationship = this.getRelationshipsByType(userId, schemaElement.getGUID(), "SchemaAttributeType", methodName);
        if (tableTypeRelationship != null && tableTypeRelationship.size() == 1) {
            EntityDetail tableType = this.getEntity(userId, schemaElement.getGUID(), tableTypeRelationship.get(0), methodName);
            if (tableType == null) {
                return Collections.emptyList();
            }
            List<Relationship> columnsRelationships = this.getRelationshipsByType(userId, tableType.getGUID(), "AttributeForSchema", methodName);
            return columnsRelationships.stream().map(columnsRelationship -> this.getEntity(userId, tableType.getGUID(), (Relationship)columnsRelationship, methodName)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<Relationship> getRelationshipsByType(String userId, String entityGUID, String type, String methodName) throws PropertyServerException {
        String schemaAttributeTypeGuid = this.getTypeGUID(type);
        return this.getRelationships(userId, schemaAttributeTypeGuid, entityGUID, methodName);
    }

    private EntityDetail getEntity(String userId, String knownId, Relationship relationship, String methodName) {
        String entityGUID = relationship.getEntityTwoProxy().getGUID().equals(knownId) ? relationship.getEntityOneProxy().getGUID() : relationship.getEntityTwoProxy().getGUID();
        try {
            return this.metadataCollection.getEntityDetail(userId, entityGUID);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Relationship> getRelationships(String userId, String relationshipTypeGUID, String entityGuid, String methodName) throws PropertyServerException {
        try {
            return this.metadataCollection.getRelationshipsForEntity(userId, entityGuid, relationshipTypeGUID, 0, null, null, null, null, 0);
        }
        catch (Exception e) {
            throw new PropertyServerException(SecurityOfficerErrorCode.UNEXPECTED_REPOSITORY_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, this.serviceName, this.serverName, e.getMessage()}), this.getClass().getName(), methodName, (Throwable)e);
        }
    }

    private boolean isRelationalTable(String typeDefName) {
        return typeDefName.equals("RelationalTable");
    }

    private boolean isSecurityTag(String name) {
        return "SecurityTags".equals(name);
    }

    private SecuritySchemaElement updateSecurityTagsClassificationForEntity(String userId, InstanceProperties instanceProperties, EntityDetail schemaElement, String methodName) throws PropertyServerException {
        EntityDetail entityDetail = this.addSecurityTagsClassification(userId, instanceProperties, schemaElement, methodName);
        SecuritySchemaElement schemaElementEntity = this.builder.buildSecuritySchemaElement(entityDetail, this.repositoryHelper);
        this.publishEventForUpdatedSecurityTags(schemaElement, schemaElementEntity);
        return schemaElementEntity;
    }

    private void publishEventForUpdatedSecurityTags(EntityDetail schemaElement, SecuritySchemaElement schemaElementEntity) throws PropertyServerException {
        SecurityOfficerUpdateTagEvent event = this.buildEventForUpdatedSecurityTags(schemaElement, schemaElementEntity);
        this.securityOfficerPublisher.publishEvent((SecurityOfficerEvent)event);
    }

    public List<SecurityClassification> getAvailableSecurityTags(String userId, String methodName) throws PropertyServerException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, UserNotAuthorizedException, TypeErrorException, FunctionNotSupportedException, ClassificationErrorException, PagingErrorException, PropertyErrorException {
        try {
            String entityTypeGuid = this.getTypeGUID("SchemaElement");
            if (entityTypeGuid == null) {
                return Collections.emptyList();
            }
            List<EntityDetail> entitiesWithSecurityTagsAssigned = this.findEntitiesWithSecurityTagsAssigned(userId, this.metadataCollection, entityTypeGuid, methodName);
            if (entitiesWithSecurityTagsAssigned == null || entitiesWithSecurityTagsAssigned.isEmpty()) {
                return Collections.emptyList();
            }
            return entitiesWithSecurityTagsAssigned.stream().flatMap(entityDetail -> entityDetail.getClassifications().stream()).filter(classification -> this.isSecurityTag(classification.getName())).map(classification -> this.builder.buildSecurityTag((Classification)classification, this.repositoryHelper)).distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new PropertyServerException(SecurityOfficerErrorCode.UNEXPECTED_REPOSITORY_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, this.serviceName, this.serverName, e.getMessage()}), this.getClass().getName(), methodName, (Throwable)e);
        }
    }

    private List<EntityDetail> findEntitiesWithSecurityTagsAssigned(String userId, OMRSMetadataCollection metadataCollection, String entityTypeGuid, String methodName) throws PropertyServerException {
        try {
            return metadataCollection.findEntitiesByClassification(userId, entityTypeGuid, "SecurityTags", null, null, 0, null, null, null, null, 0);
        }
        catch (Exception e) {
            throw new PropertyServerException(SecurityOfficerErrorCode.UNEXPECTED_REPOSITORY_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, this.serviceName, this.serverName, e.getMessage()}), this.getClass().getName(), methodName, (Throwable)e);
        }
    }

    private String getTypeGUID(String typeName) {
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(this.serviceName, typeName);
        if (typeDefByName != null) {
            return typeDefByName.getGUID();
        }
        return null;
    }

    private SecurityClassification getSecurityClassification(List<Classification> classifications) throws PropertyServerException {
        if (classifications == null || classifications.isEmpty()) {
            return null;
        }
        Optional<Classification> securityTag = classifications.stream().filter(classification -> classification.getName().equals("SecurityTags")).findAny();
        return securityTag.map(classification -> this.builder.buildSecurityTag((Classification)classification, this.repositoryHelper)).orElse(null);
    }

    private SecurityOfficerUpdateTagEvent buildEventForUpdatedSecurityTags(EntityDetail schemaElement, SecuritySchemaElement result) throws PropertyServerException {
        SecurityOfficerUpdateTagEvent event = new SecurityOfficerUpdateTagEvent();
        event.setSecuritySchemaElement(result);
        event.setPreviousClassification(this.getSecurityClassification(schemaElement.getClassifications()));
        event.setEventType(SecurityOfficerEventType.UPDATED_SECURITY_ASSIGNMENT);
        return event;
    }

    private InstanceProperties getInstanceProperties(SecurityClassification securityTagLevel) throws PropertyServerException {
        InstanceProperties instanceProperties = new InstanceProperties();
        String methodName = "getInstanceProperties";
        this.repositoryHelper.addMapPropertyToInstance("SecurityOfficerOMAS", instanceProperties, "securityProperties", securityTagLevel.getSecurityProperties(), methodName);
        this.repositoryHelper.addStringArrayPropertyToInstance("SecurityOfficerOMAS", instanceProperties, "securityLabels", securityTagLevel.getSecurityLabels(), methodName);
        return instanceProperties;
    }
}

