/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.processors;

import org.odpi.openmetadata.accessservices.securityofficer.api.model.Context;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernedAssetContextBuilder {
    private String serverUserName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;

    public GovernedAssetContextBuilder(String serverUserName, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        this.serverUserName = serverUserName;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
    }

    public Context buildContextForColumn(String userID, String assetId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "buildContextForColumn";
        EntityDetail column = this.repositoryHandler.getEntityByGUID(userID, assetId, "guid", "RelationalColumn", methodName);
        if (column != null && this.isRelationalColumn(column)) {
            return this.getDatabaseContextForColumn(userID, column);
        }
        return null;
    }

    public Context buildContextForTable(String userID, String assetId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Context context = new Context();
        context.setTable(this.getTableName(userID, assetId));
        context.setSchema("gaian");
        return context;
    }

    private Context getDatabaseContextForColumn(String userID, EntityDetail column) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseContextForColumn";
        Context context = new Context();
        String columnName = this.repositoryHelper.getStringProperty(this.serverUserName, "name", column.getProperties(), methodName);
        context.setColumn(columnName);
        context.setTable(this.getTableName(userID, column.getGUID()));
        context.setSchema("gaian");
        return context;
    }

    private String getTableName(String userID, String relationalColumnGuid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTableName";
        EntityDetail relationalTable = this.getRelationalTable(userID, relationalColumnGuid);
        if (relationalTable != null && relationalTable.getProperties() != null) {
            return this.repositoryHelper.getStringProperty(this.serverUserName, "name", relationalTable.getProperties(), methodName);
        }
        return null;
    }

    private EntityDetail getRelationalTable(String userID, String relationalColumnGuid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationalTable";
        return this.repositoryHandler.getEntityForRelationshipType(userID, relationalColumnGuid, "RelationalColumn", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", methodName);
    }

    private boolean isRelationalColumn(EntityDetail entityDetail) {
        if (entityDetail.getType() != null && entityDetail.getType().getTypeDefName() != null) {
            return entityDetail.getType().getTypeDefName().equals("RelationalColumn");
        }
        return false;
    }
}

