/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.BusinessTerm;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.Classification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.Entity;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SchemaElementEntity;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecurityClassification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecuritySchemaElement;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class Builder {
    public SecuritySchemaElement buildSecuritySchemaElement(EntityDetail entityDetail, OMRSRepositoryHelper omrsRepositoryHelper) {
        SecuritySchemaElement securitySchemaElement = new SecuritySchemaElement();
        this.buildEntity(entityDetail, (Entity)securitySchemaElement);
        SecurityClassification securityClassification = this.getSecurityClassification(entityDetail, omrsRepositoryHelper);
        if (securityClassification != null && securitySchemaElement instanceof SecuritySchemaElement) {
            securitySchemaElement.setSecurityClassification(securityClassification);
        }
        return securitySchemaElement;
    }

    private void buildEntity(EntityDetail entityDetail, Entity securitySchemaElement) {
        securitySchemaElement.setGuid(entityDetail.getGUID());
        securitySchemaElement.setStatus(entityDetail.getStatus().getName());
        securitySchemaElement.setType(entityDetail.getType().getTypeDefName());
        securitySchemaElement.setCreatedBy(entityDetail.getCreatedBy());
        securitySchemaElement.setCreatedTime(entityDetail.getCreateTime());
        securitySchemaElement.setUpdatedBy(entityDetail.getUpdatedBy());
        securitySchemaElement.setUpdatedTime(entityDetail.getUpdateTime());
        securitySchemaElement.setProperties(this.getProperties(entityDetail.getProperties()));
    }

    public SchemaElementEntity buildSchemaElementContext(EntityDetail schemaElement, EntityDetail glossaryTerm) {
        SchemaElementEntity schemaElementEntity = this.buildSchemaElement(schemaElement);
        schemaElementEntity.setBusinessTerm(this.buildBusinessTerm(glossaryTerm));
        return schemaElementEntity;
    }

    public SecurityClassification buildSecurityTag(org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification classification, OMRSRepositoryHelper repositoryHelper) {
        SecurityClassification securityClassification = new SecurityClassification();
        if (classification.getProperties() != null) {
            List securityLabels = repositoryHelper.getStringArrayProperty("SecurityOfficerOMAS", "securityLabels", classification.getProperties(), "buildSecurityTag");
            Map securityProperties = repositoryHelper.getMapFromProperty("SecurityOfficerOMAS", "securityProperties", classification.getProperties(), "buildSecurityTag");
            securityClassification.setSecurityLabels(securityLabels);
            securityClassification.setSecurityProperties(securityProperties);
        }
        return securityClassification;
    }

    public List<SecuritySchemaElement> buildSecuritySchemaElementList(List<EntityDetail> entityDetailList, OMRSRepositoryHelper repositoryHelper) {
        return entityDetailList.stream().map(entityDetail -> this.buildSecuritySchemaElement((EntityDetail)entityDetail, repositoryHelper)).collect(Collectors.toList());
    }

    private SchemaElementEntity buildSchemaElement(EntityDetail entityDetail) {
        SchemaElementEntity schemaElementEntity = new SchemaElementEntity();
        this.buildEntity(entityDetail, (Entity)schemaElementEntity);
        schemaElementEntity.setClassifications(this.getClassifications(entityDetail.getClassifications()));
        return schemaElementEntity;
    }

    private BusinessTerm buildBusinessTerm(EntityDetail entityDetail) {
        BusinessTerm businessTerm = new BusinessTerm();
        this.buildEntity(entityDetail, (Entity)businessTerm);
        businessTerm.setClassifications(this.getClassifications(entityDetail.getClassifications()));
        return businessTerm;
    }

    private List<Classification> getClassifications(List<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification> existingClassifications) {
        if (existingClassifications == null || existingClassifications.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        existingClassifications.forEach(classification -> classifications.add(this.buildClassification((org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification)classification)));
        return classifications;
    }

    private Classification buildClassification(org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification classification) {
        Classification newClassification = new Classification();
        newClassification.setName(classification.getName());
        newClassification.setType(classification.getType().getTypeDefName());
        newClassification.setProperties(this.getProperties(classification.getProperties()));
        return newClassification;
    }

    private SecurityClassification getSecurityClassification(EntityDetail entityDetail, OMRSRepositoryHelper omrsRepositoryHelper) {
        Optional<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification> securityTag;
        if (entityDetail.getClassifications() != null && !entityDetail.getClassifications().isEmpty() && (securityTag = this.getSecurityTag(entityDetail.getClassifications())).isPresent()) {
            return this.buildSecurityTag(securityTag.get(), omrsRepositoryHelper);
        }
        return null;
    }

    private Optional<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification> getSecurityTag(List<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification> classifications) {
        return classifications.stream().filter(classification -> classification.getName().equals("SecurityTags")).findAny();
    }

    private Map<String, String> getProperties(InstanceProperties uniqueProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        uniqueProperties.getInstanceProperties().forEach((k, v) -> properties.put((String)k, this.getStringForPropertyValue((InstancePropertyValue)v)));
        return properties;
    }

    private String getStringForPropertyValue(InstancePropertyValue ipv) {
        if (ipv instanceof PrimitivePropertyValue) {
            PrimitiveDefCategory primtype = ((PrimitivePropertyValue)ipv).getPrimitiveDefCategory();
            switch (primtype) {
                case OM_PRIMITIVE_TYPE_STRING: {
                    return (String)((PrimitivePropertyValue)ipv).getPrimitiveValue();
                }
                case OM_PRIMITIVE_TYPE_INT: 
                case OM_PRIMITIVE_TYPE_BIGDECIMAL: 
                case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                case OM_PRIMITIVE_TYPE_BOOLEAN: 
                case OM_PRIMITIVE_TYPE_BYTE: 
                case OM_PRIMITIVE_TYPE_CHAR: 
                case OM_PRIMITIVE_TYPE_DATE: 
                case OM_PRIMITIVE_TYPE_DOUBLE: 
                case OM_PRIMITIVE_TYPE_FLOAT: 
                case OM_PRIMITIVE_TYPE_LONG: 
                case OM_PRIMITIVE_TYPE_SHORT: {
                    return ((PrimitivePropertyValue)ipv).getPrimitiveValue().toString();
                }
            }
            return "";
        }
        if (ipv instanceof EnumPropertyValue) {
            return ((EnumPropertyValue)ipv).getSymbolicName();
        }
        return "";
    }
}

