/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.server.listener;

import java.util.List;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.GovernedAssetEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerEventType;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.SecurityOfficerAuditCode;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.GovernedAsset;
import org.odpi.openmetadata.accessservices.securityofficer.server.handler.GovernedAssetHandler;
import org.odpi.openmetadata.accessservices.securityofficer.server.publisher.SecurityOfficerPublisher;
import org.odpi.openmetadata.accessservices.securityofficer.server.services.SecurityOfficerInstanceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOfficerOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(SecurityOfficerOMRSTopicListener.class);
    private static SecurityOfficerInstanceHandler instanceHandler = new SecurityOfficerInstanceHandler();
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSRepositoryValidator repositoryValidator;
    private String componentName;
    private String serverName;
    private String serverUserId;
    private List<String> supportedZones;
    private SecurityOfficerPublisher publisher;

    public SecurityOfficerOMRSTopicListener(SecurityOfficerPublisher securityOfficerPublisher, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String componentName, String serverName, String serverUserId, List<String> supportedZones, AuditLog auditLog) {
        super(componentName, auditLog);
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.componentName = componentName;
        this.serverName = serverName;
        this.serverUserId = serverUserId;
        this.supportedZones = supportedZones;
        this.publisher = securityOfficerPublisher;
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        if (instanceEvent == null) {
            log.debug("Null instance event - ignoring event");
        } else {
            OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
            OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
            if (instanceEventType == null || instanceEventOriginator == null) {
                return;
            }
            switch (instanceEventType) {
                case CLASSIFIED_ENTITY_EVENT: {
                    break;
                }
                case RECLASSIFIED_ENTITY_EVENT: {
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    break;
                }
                case DECLASSIFIED_ENTITY_EVENT: {
                    break;
                }
                default: {
                    log.debug("Unknown instance event error code, ignoring event");
                }
            }
        }
    }

    public void processClassifiedEntityEvent(OMRSInstanceEvent instanceEvent) {
        String methodName = "processClassifiedEntityEvent";
        EntityDetail entity = instanceEvent.getEntity();
        String eventTypeName = instanceEvent.getInstanceEventType().getName();
        this.logEvent(eventTypeName, entity);
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(this.serverUserId, this.serverName, methodName);
            if (!governedAssetHandler.isSchemaElement(entity.getType()) || !governedAssetHandler.containsGovernedClassification(entity)) {
                this.logNoProcessEvent(eventTypeName, entity);
                return;
            }
            GovernedAssetEvent governanceEngineEvent = this.getGovernanceEngineEvent(entity, SecurityOfficerEventType.NEW_CLASSIFIED_ASSET);
            this.publisher.publishEvent((SecurityOfficerEvent)governanceEngineEvent);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logExceptionToAudit(methodName, instanceEvent, (Exception)e);
        }
    }

    public void processReclassifiedEntityEvent(OMRSInstanceEvent instanceEvent) {
        String methodName = "processReclassifiedEntityEvent";
        EntityDetail entity = instanceEvent.getEntity();
        String eventTypeName = instanceEvent.getInstanceEventType().getName();
        this.logEvent(eventTypeName, entity);
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(this.serverUserId, this.serverName, methodName);
            if (governedAssetHandler != null && !governedAssetHandler.isSchemaElement(entity.getType())) {
                this.logNoProcessEvent(eventTypeName, entity);
                return;
            }
            GovernedAssetEvent governanceEngineEvent = this.getGovernanceEngineEvent(entity, SecurityOfficerEventType.RE_CLASSIFIED_ASSET);
            this.publisher.publishEvent((SecurityOfficerEvent)governanceEngineEvent);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logExceptionToAudit(methodName, instanceEvent, (Exception)e);
        }
    }

    public void processDeletePurgedEntityEvent(OMRSInstanceEvent instanceEvent) {
        String methodName = "processDeletePurgedEntityEvent";
        EntityDetail entity = instanceEvent.getEntity();
        String eventTypeName = instanceEvent.getInstanceEventType().getName();
        this.logEvent(eventTypeName, entity);
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(this.serverUserId, this.serverName, methodName);
            if (!(governedAssetHandler == null || governedAssetHandler.isSchemaElement(entity.getType()) && governedAssetHandler.containsGovernedClassification(entity))) {
                this.logNoProcessEvent(eventTypeName, entity);
                return;
            }
            GovernedAssetEvent governanceEngineEvent = this.getGovernanceEngineEvent(entity, SecurityOfficerEventType.DELETED_ASSET);
            this.publisher.publishEvent((SecurityOfficerEvent)governanceEngineEvent);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logExceptionToAudit(methodName, instanceEvent, (Exception)e);
        }
    }

    public void processDeclassifiedEntityEvent(OMRSInstanceEvent instanceEvent) {
        String methodName = "processDeclassifiedEntityEvent";
        EntityDetail entity = instanceEvent.getEntity();
        String eventTypeName = instanceEvent.getInstanceEventType().getName();
        this.logEvent(eventTypeName, entity);
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(this.serverUserId, this.serverName, methodName);
            if (governedAssetHandler != null && !governedAssetHandler.isSchemaElement(entity.getType())) {
                this.logNoProcessEvent(eventTypeName, entity);
                return;
            }
            GovernedAssetEvent governanceEngineEvent = this.getGovernanceEngineEvent(entity, SecurityOfficerEventType.DE_CLASSIFIED_ASSET);
            this.publisher.publishEvent((SecurityOfficerEvent)governanceEngineEvent);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logExceptionToAudit(methodName, instanceEvent, (Exception)e);
        }
    }

    private GovernedAssetEvent getGovernanceEngineEvent(EntityDetail entityDetail, SecurityOfficerEventType governanceEngineEventType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceEngineEvent";
        GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(this.serverUserId, this.serverName, methodName);
        if (governedAssetHandler == null) {
            return null;
        }
        GovernedAssetEvent governanceEvent = new GovernedAssetEvent();
        governanceEvent.setEventType(governanceEngineEventType);
        GovernedAsset governedAsset = governedAssetHandler.convertGovernedAsset(this.serverUserId, entityDetail);
        governanceEvent.setGovernedAsset(governedAsset);
        return governanceEvent;
    }

    private void logEvent(String eventType, EntityDetail entityDetail) {
        log.debug("{} received event {} for entity GUID = {} - type = {}", new Object[]{this.serverUserId, eventType, entityDetail.getGUID(), entityDetail.getType().getTypeDefName()});
    }

    private void logNoProcessEvent(String eventTypeName, EntityDetail entityDetail) {
        log.debug("Event received {} for entity GUID = {} - type = {} is not processed by {}", new Object[]{eventTypeName, entityDetail.getGUID(), entityDetail.getType().getTypeDefName(), this.serverUserId});
    }

    private void logExceptionToAudit(String methodName, OMRSInstanceEvent instanceEvent, Exception error) {
        this.auditLog.logException(methodName, SecurityOfficerAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{instanceEvent.getInstanceEventType().getName()}), "instanceEvent {" + instanceEvent.toString() + "}", (Throwable)error);
    }
}

