/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.securityofficer.admin;

import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.ViewServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.securityofficer.ffdc.SecurityOfficerAuditCode;
import org.odpi.openmetadata.viewservices.securityofficer.server.SecurityOfficerInstance;

public class SecurityOfficerAdmin
extends ViewServiceAdmin {
    private AuditLog auditLog = null;
    private SecurityOfficerInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfig, AuditLog auditLog, String serverUserName, int maxPageSize) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", SecurityOfficerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        this.serverName = serverName;
        try {
            this.instance = new SecurityOfficerInstance(serverName, auditLog, serverUserName, maxPageSize, viewServiceConfig.getOMAGServerName(), viewServiceConfig.getOMAGServerPlatformRootURL());
            auditLog.logMessage("initialize", SecurityOfficerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(), viewServiceConfig.toString());
        }
        catch (Exception error) {
            auditLog.logException("initialize", SecurityOfficerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(error.getMessage()), viewServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", ViewServiceDescription.SECURITY_OFFICER.getViewServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", SecurityOfficerAuditCode.SERVICE_TERMINATING.getMessageDefinition(this.serverName));
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", SecurityOfficerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
    }
}

