/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.securityofficer.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum SecurityOfficerAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMVS-SECURITY-OFFICER-0001", AuditLogRecordSeverityLevel.STARTUP, "The Security Officer Open Metadata View Service (OMVS) is initializing", "The local server is initializing the Security Officer Open Metadata View Service. If the initialization is successful then audit message OMVS-SECURITY-OFFICER-0002 will be issued, if there were errors then they should be shown in the audit log. ", "No action is required. This is part of the normal operation of the Security Officer Open Metadata View Service."),
    SERVICE_INITIALIZED("OMVS-SECURITY-OFFICER-0002", AuditLogRecordSeverityLevel.STARTUP, "The Security Officer Open Metadata View Service (OMVS) is initialized", "The Security Officer OMVS has completed initialization. Calls will be accepted by this service, if OMRS is also configured and the view server has been started. ", "No action is required.  This is part of the normal operation of the Security Officer Open Metadata View Service. Once the OMRS is configured and the server is started, Security Officer view service requests can be accepted."),
    SERVICE_SHUTDOWN("OMVS-SECURITY-OFFICER-0003", AuditLogRecordSeverityLevel.SHUTDOWN, "The Security Officer Open Metadata View Service (OMVS) is shutting down", "The local server has requested shutdown of the Security Officer OMVS.", "No action is required. The operator should verify that shutdown was intended. This is part of the normal operation of the Security Officer OMVS."),
    SERVICE_INSTANCE_FAILURE("OMVS-SECURITY-OFFICER-0004", AuditLogRecordSeverityLevel.EXCEPTION, "The Security Officer Open Metadata View Service (OMVS) is unable to initialize a new instance; error message is {0}", "The view service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_TERMINATING("OMVS-SECURITY-OFFICER-0005", AuditLogRecordSeverityLevel.SHUTDOWN, "The Security Officer Open Metadata View Service (OMVS) is shutting down server instance {0}", "The local handler has requested shut down of the Security Officer OMVS.", "No action is required. This is part of the normal operation of the service."),
    UNEXPECTED_EXCEPTION("OMVS-SECURITY-OFFICER-0006", AuditLogRecordSeverityLevel.EXCEPTION, "The Open Metadata Service has generated an unexpected {0} exception during method {1}.  The message was: {2}", "The request returned an Exception.", "This is probably a logic error. Review the stack trace to identify where the error occurred and work to resolve the cause.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private SecurityOfficerAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "SecurityOfficerAuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "', messageDefinition=" + String.valueOf(this.getMessageDefinition()) + "}";
    }
}

