/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.securityofficerservices.registration;

import org.odpi.openmetadata.adminservices.configuration.properties.SecurityOfficerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.odpi.openmetadata.securityofficerservices.auditlog.SecurityOfficerAuditCode;
import org.odpi.openmetadata.securityofficerservices.listener.SecurityOfficerEventListener;
import org.odpi.openmetadata.securityofficerservices.processor.SecurityOfficerEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOfficerOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(SecurityOfficerConfig.class);
    private OpenMetadataTopicConnector inTopic;
    private String localServerName;
    private String localServerType;
    private String localMetadataCollectionName;
    private String localOrganizationName;
    private String localServerUserId;
    private String localServerURL;
    private int maxPageSize;
    private OMRSAuditLog auditLog;

    public SecurityOfficerOperationalServices(String localServerName, String localServerType, String localOrganizationName, String localServerUserId, String localServerURL, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.localServerUserId = localServerUserId;
        this.localServerURL = localServerURL;
        this.maxPageSize = maxPageSize;
    }

    public void initialize(SecurityOfficerConfig securityOfficerConfig, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        if (securityOfficerConfig != null) {
            String actionDescription = "initialize";
            this.auditLog = auditLog;
            this.logAudit(SecurityOfficerAuditCode.SERVICE_INITIALIZING, "initialize");
            SecurityOfficerEventProcessor securityOfficerEventProcessor = new SecurityOfficerEventProcessor(securityOfficerConfig, auditLog);
            this.inTopic = this.getTopicConnector(securityOfficerConfig.getSecurityOfficerServerInTopic(), auditLog);
            SecurityOfficerEventListener securityOfficerEventListener = new SecurityOfficerEventListener(securityOfficerEventProcessor);
            this.inTopic.registerListener((OpenMetadataTopicListener)securityOfficerEventListener);
            this.startTopic(this.inTopic, securityOfficerConfig.getSecurityOfficerServerInTopicName());
            this.logAudit(SecurityOfficerAuditCode.SERVICE_INITIALIZED, "initialize");
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, OMRSAuditLog auditLog) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog(auditLog);
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getTopicConnector"});
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
        }
    }

    public boolean disconnect() {
        try {
            this.inTopic.disconnect();
        }
        catch (ConnectorCheckedException e) {
            log.error("Error disconnecting in topic connector");
        }
        String actionDescription = "shutdown";
        this.logAudit(SecurityOfficerAuditCode.SERVICE_SHUTDOWN, "shutdown");
        return false;
    }

    private void startTopic(OpenMetadataTopicConnector topic, String topicName) throws OMAGConfigurationErrorException {
        try {
            topic.start();
        }
        catch (ConnectorCheckedException e) {
            String action = "Unable to initialize the topic connection";
            SecurityOfficerAuditCode auditCode = SecurityOfficerAuditCode.ERROR_INITIALIZING_SECURITY_OFFICER_SERVER_TOPIC_CONNECTION;
            this.auditLog.logRecord(action, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicName, this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMAGConfigurationErrorException(400, this.getClass().getSimpleName(), action, auditCode.getFormattedLogMessage(new String[0]), auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void logAudit(SecurityOfficerAuditCode auditCode, String actionDescription) {
        this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), OMRSAuditLogRecordSeverity.INFO, auditCode.getFormattedLogMessage("Security Officer Server"), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

