/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.securityofficerservices.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.Collections;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SchemaElementEntity;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecurityClassification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerOMASAPIResponse;
import org.odpi.openmetadata.adminservices.configuration.properties.SecurityOfficerConfig;
import org.odpi.openmetadata.openconnector.governancedarmonconnectors.securityofficerconnectors.SecurityOfficerConnector;
import org.odpi.openmetadata.openconnector.governancedarmonconnectors.securityofficerconnectors.securitytagconnector.SecurityTagConnector;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class SecurityOfficerEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(SecurityOfficerEventProcessor.class);
    private static final String SECURITY_OFFICER_SERVER = "SecurityOfficerServer";
    private static final String SECURITY_OFFICER_OMAS_URL = "{0}/servers/{1}/open-metadata/access-services/security-officer/users/{2}/security-tag/element/{3}";
    private OMRSAuditLog auditLog;
    private SecurityOfficerConfig securitySyncConfig;
    private SecurityOfficerConnector connector;

    public SecurityOfficerEventProcessor(SecurityOfficerConfig securityOfficerConfig, OMRSAuditLog auditLog) {
        this.auditLog = auditLog;
        this.securitySyncConfig = securityOfficerConfig;
        this.connector = new SecurityTagConnector();
    }

    public void processNewAssignment(SchemaElementEntity schemaElementEntity) {
        if (schemaElementEntity == null) {
            return;
        }
        SecurityClassification securityClassification = this.connector.resolveSecurityClassification(schemaElementEntity);
        this.setSecurityTag(schemaElementEntity.getGuid(), securityClassification);
    }

    public void processDeletedSecurityTag(SchemaElementEntity schemaElementEntity) {
        if (schemaElementEntity == null) {
            return;
        }
        this.deleteSecurityTag(schemaElementEntity.getGuid());
    }

    private void deleteSecurityTag(String schemaElementGuid) {
        String securityOMASURL = this.getSecurityOMASURL(schemaElementGuid);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getBasicHTTPHeaders());
        try {
            restTemplate.exchange(securityOMASURL, HttpMethod.DELETE, entity, SchemaElementEntity.class, new Object[0]);
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to delete the security tag for schema element {}", (Object)schemaElementGuid);
        }
    }

    private void setSecurityTag(String guid, SecurityClassification securityClassification) {
        String securityOMASURL = this.getSecurityOMASURL(guid);
        String securityClassificationBody = this.getBody(securityClassification);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity((Object)securityClassificationBody, (MultiValueMap)this.getBasicHTTPHeaders());
        try {
            ResponseEntity elementEntity = restTemplate.exchange(securityOMASURL, HttpMethod.POST, entity, SecurityOfficerOMASAPIResponse.class, new Object[0]);
            if (elementEntity.getBody() != null) {
                log.debug("result of setting the security tag: {}", elementEntity.getBody());
            }
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to set/update the security tag for schema element {}", (Object)guid);
        }
    }

    private String getBody(Object resource) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(resource);
        }
        catch (JsonProcessingException e) {
            log.error("error write json ");
            return null;
        }
    }

    private String getSecurityOMASURL(String guid) {
        return MessageFormat.format(SECURITY_OFFICER_OMAS_URL, this.securitySyncConfig.getAccessServiceRootURL(), this.securitySyncConfig.getAccessServiceServerName(), SECURITY_OFFICER_SERVER, guid);
    }

    private HttpHeaders getBasicHTTPHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }
}

