/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.securityofficerservices.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum SecurityOfficerAuditCode {
    SERVICE_INITIALIZING("SECURITY-OFFICER-SERVER-0001", OMRSAuditLogRecordSeverity.INFO, "The Security Officer Server is initializing a new server instance", "The local server has started up a new instance of the Security Officer Server.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("SECURITY-OFFICER-SERVER-0002", OMRSAuditLogRecordSeverity.INFO, "The Security Officer Server has initialized a new instance for server {0}", "The Security Officer Server has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("SECURITY-OFFICER-SERVER-0003", OMRSAuditLogRecordSeverity.INFO, "The Security Officer Server is shutting down its instance for server {0}", "The local server has requested shut down of a Security Officer Server instance.", "No action is required.  This is part of the normal operation of the service."),
    ERROR_INITIALIZING_SECURITY_OFFICER_SERVER_TOPIC_CONNECTION("SECURITY-OFFICER-SERVER-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The Security Officer Server is unable to initialize the connection to topic {0} in the instance for server {1} ", "The connection to topic could not be initialized.", "Review the exception and resolve the configuration.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private SecurityOfficerAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }
}

