/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.spring;

import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecurityClassification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerOMASAPIResponse;
import org.odpi.openmetadata.accessservices.securityofficer.server.admin.services.SecurityOfficerService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/security-officer/users/{userId}"})
public class SecurityOfficerOMASResource {
    private SecurityOfficerService service = new SecurityOfficerService();

    @GetMapping(path={"/security-tag/element/{schemaElementId}"}, produces={"application/json"})
    public SecurityOfficerOMASAPIResponse getSecurityTagBySchemaElementIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementId) {
        return this.service.getSecurityTagBySchemaElementId(serverName, userId, schemaElementId);
    }

    @PostMapping(path={"/security-tag/element/{schemaElementId}"}, produces={"application/json"})
    public SecurityOfficerOMASAPIResponse getSecurityTagBySchemaElementIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementId, @RequestBody SecurityClassification securityTagClassification) {
        return this.service.updateSecurityTag(serverName, userId, schemaElementId, securityTagClassification);
    }

    @DeleteMapping(path={"/security-tag/element/{schemaElementId}"}, produces={"application/json"})
    public SecurityOfficerOMASAPIResponse deleteSecurityTagBySchemaElementIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementId) {
        return this.service.deleteSecurityTag(serverName, userId, schemaElementId);
    }

    @GetMapping(path={"/security-tag"}, produces={"application/json"})
    public SecurityOfficerOMASAPIResponse getSecurityTagBySchemaElementIdentifier(@PathVariable String serverName, @PathVariable String userId) {
        return this.service.getSecurityTags(serverName, userId);
    }
}

