/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.SecurityClassification;
import org.odpi.openmetadata.accessservices.securityofficer.api.model.rest.SecurityOfficerOMASAPIResponse;
import org.odpi.openmetadata.accessservices.securityofficer.server.services.SecurityOfficerRESTService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/security-officer/users/{userId}"})
@Tag(name="Security Officer OMAS", description="The Security Officer Open Metadata Access Service (OMAS) provides access to metadata for policy enforcement frameworks such as Apache Ranger.", externalDocs=@ExternalDocumentation(description="Security Officer Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/security-officer/overview/"))
public class SecurityOfficerOMASResource {
    private SecurityOfficerRESTService service = new SecurityOfficerRESTService();

    @GetMapping(path={"/security-tag/element/{schemaElementId}"}, produces={"application/json"})
    public SecurityOfficerOMASAPIResponse getSecurityTagBySchemaElementIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementId) {
        return this.service.getSecurityTagBySchemaElementId(serverName, userId, schemaElementId);
    }

    @PostMapping(path={"/security-tag/element/{schemaElementId}"}, produces={"application/json"})
    public SecurityOfficerOMASAPIResponse getSecurityTagBySchemaElementIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementId, @RequestBody SecurityClassification securityTagClassification) {
        return this.service.updateSecurityTag(serverName, userId, schemaElementId, securityTagClassification);
    }

    @DeleteMapping(path={"/security-tag/element/{schemaElementId}"}, produces={"application/json"})
    public SecurityOfficerOMASAPIResponse deleteSecurityTagBySchemaElementIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementId) {
        return this.service.deleteSecurityTag(serverName, userId, schemaElementId);
    }

    @GetMapping(path={"/security-tag"}, produces={"application/json"})
    public SecurityOfficerOMASAPIResponse getSecurityTagBySchemaElementIdentifier(@PathVariable String serverName, @PathVariable String userId) {
        return this.service.getSecurityTags(serverName, userId);
    }
}

