/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securityofficer.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.securityofficer.api.SecurityOfficerEventInterface;
import org.odpi.openmetadata.accessservices.securityofficer.api.SecurityOfficerEventListener;
import org.odpi.openmetadata.accessservices.securityofficer.api.events.SecurityOfficerEvent;
import org.odpi.openmetadata.accessservices.securityofficer.api.ffdc.SecurityOfficerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOfficerOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements SecurityOfficerEventInterface {
    private static final Logger log = LoggerFactory.getLogger(SecurityOfficerOutTopicClientConnector.class);
    private List<SecurityOfficerEventListener> internalEventListeners = new ArrayList<SecurityOfficerEventListener>();

    public synchronized void registerListener(String userId, SecurityOfficerEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(SecurityOfficerErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                SecurityOfficerEvent eventObject = (SecurityOfficerEvent)super.getEventBean(event, SecurityOfficerEvent.class);
                for (SecurityOfficerEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

