/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.securitysyncservices.auditlog;

import java.text.MessageFormat;

public enum SecuritySyncAuditCode {
    SERVICE_INITIALIZING("SECURITY-SYNC-0001", "The Security Sync is initializing a new server instance", "The local server has started up a new instance of the Security Sync.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("SECURITY-SYNC-0002", "The Security Sync has initialized a new instance for server {0}", "The Security Sync has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("SECURITY-SYNC-0003", "The Security Sync is shutting down its instance for server {0}", "The local server has requested shut down of a Security Sync instance.", "No action is required.  This is part of the normal operation of the service.");

    private String logMessageId;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private SecuritySyncAuditCode(String messageId, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

