/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.securitysyncservices.processor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.json.JsonSanitizer;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassification;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAsset;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.RangerSecurityServiceConnector;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerSecurityServicePolicies;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerServiceResource;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.model.RangerTag;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.securitysyncservices.auditlog.SecuritySyncAuditCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class SecuritySyncEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(SecuritySyncEventProcessor.class);
    private static final Long DEFAULT_POLLING_INTERVAL = 360L;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private OMRSAuditLog auditLog;
    private SecuritySyncConfig securitySyncConfig;
    private RangerSecurityServiceConnector rangerOpenConnector;
    private Long tagPoliciesLastKnownVersion = 0L;
    private Long accessPoliciesLastKnownVersion = 0L;

    public SecuritySyncEventProcessor(SecuritySyncConfig securitySyncConfig, OMRSAuditLog auditLog) {
        this.auditLog = auditLog;
        this.securitySyncConfig = securitySyncConfig;
        this.rangerOpenConnector = new RangerSecurityServiceConnector(securitySyncConfig.getSecuritySyncServerConnection());
    }

    public void processExistingGovernedAssetsFromRepository() {
        this.logProcessing("processExistingGovernedAssetsFromRepository", SecuritySyncAuditCode.CLASSIFIED_GOVERNED_ASSET_INITIAL_LOAD);
        GovernedAssetListAPIResponse governedAssetResponse = this.getGovernedAssets();
        if (governedAssetResponse == null || governedAssetResponse.getRelatedHTTPCode() != 200) {
            return;
        }
        List governedAssets = governedAssetResponse.getGovernedAssetList();
        this.rangerOpenConnector.importTaggedResources(governedAssets);
    }

    public void syncSecurityPolicies() {
        Runnable syncSecurityServicePolicies = () -> {
            log.debug("Re-sync policies from external tool");
            this.processSecurityServicePolicies();
        };
        this.scheduler.scheduleAtFixedRate(syncSecurityServicePolicies, this.securitySyncConfig.getPollingInterval() != null ? this.securitySyncConfig.getPollingInterval() : DEFAULT_POLLING_INTERVAL, this.securitySyncConfig.getPollingInterval() != null ? this.securitySyncConfig.getPollingInterval() : DEFAULT_POLLING_INTERVAL, TimeUnit.SECONDS);
    }

    public void processSecurityServicePolicies() {
        String methodName = "processSecurityServicePolicies";
        this.logProcessing(methodName, SecuritySyncAuditCode.SYNCHRONIZE_POLICIES_STARTED);
        this.syncSecurityServicePolicies(this.securitySyncConfig.getSecuritySyncTagServiceName(), this.tagPoliciesLastKnownVersion);
        this.syncSecurityServicePolicies(this.securitySyncConfig.getSecuritySyncAccessResourceServiceName(), this.accessPoliciesLastKnownVersion);
        this.logProcessing(methodName, SecuritySyncAuditCode.SYNCHRONIZE_POLICIES_FINISHED);
    }

    public void processClassifiedGovernedAssetEvent(GovernedAsset governedAsset) {
        this.logProcessing("processClassifiedGovernedAssetEvent", SecuritySyncAuditCode.CLASSIFIED_GOVERNED_ASSET_EVENT_RECEIVED);
        List securityTags = this.rangerOpenConnector.createSecurityTags(governedAsset.getAssignedGovernanceClassification());
        if (securityTags == null || securityTags.isEmpty()) {
            return;
        }
        RangerServiceResource resource = this.rangerOpenConnector.createResource(governedAsset);
        for (RangerTag securityTag : securityTags) {
            this.rangerOpenConnector.createAssociationResourceToSecurityTag(resource.getGuid(), securityTag.getGuid());
        }
    }

    public void processReClassifiedGovernedAssetEvent(GovernedAsset governedAsset) {
        this.logProcessing("processReClassifiedGovernedAssetEvent", SecuritySyncAuditCode.RE_CLASSIFIED_GOVERNED_ASSET_EVENT_RECEIVED);
        RangerServiceResource resource = this.declassifiedGovernedAsset(governedAsset);
        if (governedAsset.getAssignedGovernanceClassification() == null) {
            return;
        }
        GovernanceClassification classification = governedAsset.getAssignedGovernanceClassification();
        if (classification.getSecurityLabels() == null || classification.getSecurityLabels().isEmpty()) {
            return;
        }
        List securityTags = this.rangerOpenConnector.createSecurityTags(classification);
        if (resource != null && resource.getGuid() != null) {
            for (RangerTag securityTag : securityTags) {
                this.rangerOpenConnector.createAssociationResourceToSecurityTag(resource.getGuid(), securityTag.getGuid());
            }
        }
    }

    public void processDeClassifiedGovernedAssetEvent(GovernedAsset governedAsset) {
        this.logProcessing("processDeclassifiedGovernedAssetEvent", SecuritySyncAuditCode.DE_CLASSIFIED_GOVERNED_ASSET_EVENT_RECEIVED);
        this.declassifiedGovernedAsset(governedAsset);
    }

    public void processDeletedGovernedAssetEvent(GovernedAsset governedAsset) {
        this.logProcessing("processDeclassifiedGovernedAssetEvent", SecuritySyncAuditCode.DELETED_GOVERNED_ASSET_EVENT_RECEIVED);
        RangerServiceResource resource = this.declassifiedGovernedAsset(governedAsset);
        if (resource != null && resource.getGuid() != null) {
            this.rangerOpenConnector.deleteResource(resource.getGuid());
        }
    }

    private void logProcessing(String action, SecuritySyncAuditCode auditCode) {
        this.auditLog.logRecord(action, auditCode.getLogMessageId(), OMRSAuditLogRecordSeverity.INFO, auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    private GovernedAssetListAPIResponse getGovernedAssets() {
        String governanceEngineURL = this.getGovernanceEngineURL();
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity result = restTemplate.exchange(governanceEngineURL, HttpMethod.GET, entity, String.class, new Object[0]);
            return (GovernedAssetListAPIResponse)this.mapToObject((ResponseEntity<String>)result, GovernedAssetListAPIResponse.class);
        }
        catch (HttpStatusCodeException exception) {
            log.debug("Unable to get the governed assets!");
            return null;
        }
    }

    private String getGovernanceEngineURL() {
        return MessageFormat.format("{0}/servers/{1}/open-metadata/access-services/governance-engine/users/{2}/assets?classification={3}", this.securitySyncConfig.getAccessServiceRootURL(), this.securitySyncConfig.getAccessServiceServerName(), "SecuritySyncServer", "SecurityTags");
    }

    private Object mapToObject(ResponseEntity<String> result, Class className) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            String resultString = JsonSanitizer.sanitize((String)((String)result.getBody()));
            return mapper.readValue(resultString, className);
        }
        catch (IOException e) {
            log.error("403", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private RangerServiceResource declassifiedGovernedAsset(GovernedAsset governedAsset) {
        if (governedAsset == null) {
            return null;
        }
        log.debug("de-classified entity: {}", (Object)governedAsset.getGuid());
        RangerServiceResource resource = this.rangerOpenConnector.getResourceByGUID(governedAsset.getGuid());
        if (resource == null) {
            return null;
        }
        List resourceTagMapper = this.rangerOpenConnector.getTagsAssociatedWithTheResource(resource.getId());
        if (resourceTagMapper != null) {
            resourceTagMapper.forEach(mapping -> this.rangerOpenConnector.deleteAssociationResourceToSecurityTag(mapping));
        }
        return resource;
    }

    private void syncSecurityServicePolicies(String securitySyncServiceName, Long tagPoliciesLastKnownVersion) {
        if (securitySyncServiceName == null) {
            return;
        }
        RangerSecurityServicePolicies securityServicePolicies = this.rangerOpenConnector.getSecurityServicePolicies(securitySyncServiceName, tagPoliciesLastKnownVersion);
        if (securityServicePolicies != null) {
            this.setLastKnownVersion(securitySyncServiceName, securityServicePolicies);
        }
    }

    private void setLastKnownVersion(String securitySyncTagServiceName, RangerSecurityServicePolicies securityServicePolicies) {
        if (securitySyncTagServiceName.startsWith("tag")) {
            this.tagPoliciesLastKnownVersion = securityServicePolicies.getPolicyVersion();
        } else {
            this.accessPoliciesLastKnownVersion = securityServicePolicies.getPolicyVersion();
        }
    }
}

