/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.securitysyncservices.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum SecuritySyncAuditCode {
    SERVICE_INITIALIZING("SECURITY-SYNC-0001", OMRSAuditLogRecordSeverity.INFO, "The Security Sync is initializing a new server instance", "The local server has started up a new instance of the Security Sync.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("SECURITY-SYNC-0002", OMRSAuditLogRecordSeverity.INFO, "The Security Sync has initialized a new instance for server {0}", "The Security Sync has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("SECURITY-SYNC-0003", OMRSAuditLogRecordSeverity.INFO, "The Security Sync is shutting down its instance for server {0}", "The local server has requested shut down of a Security Sync instance.", "No action is required.  This is part of the normal operation of the service."),
    ERROR_INITIALIZING_SECURITY_SYNC_TOPIC_CONNECTION("SECURITY-SYNC-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The Security Sync is unable to initialize the connection to topic {0} in the instance for server {1} ", "The connection to topic could not be initialized.", "Review the exception and resolve the configuration."),
    CLASSIFIED_GOVERNED_ASSET_INITIAL_LOAD("SECURITY-SYNC--0005", OMRSAuditLogRecordSeverity.INFO, "The Security Sync exchange the classified governed asset from Open Metadata Repository with configured Security Sync Server", "The Security Sync instance synchronize the Ranger Server with the repository for initial loading of existing governed assets", "No action is required.  This is part of the normal flow of the initial load."),
    CLASSIFIED_GOVERNED_ASSET_EVENT_RECEIVED("SECURITY-SYNC--0006", OMRSAuditLogRecordSeverity.INFO, "The Security Sync received a new event for classified governed asset", "The Security Sync instance should synchronize the Ranger Server instance with the repository.", "No action is required.  This is part of the normal flow."),
    RE_CLASSIFIED_GOVERNED_ASSET_EVENT_RECEIVED("SECURITY-SYNC--0007", OMRSAuditLogRecordSeverity.INFO, "The Security Sync received a new event for re-classified governed asset", "The Security Sync instance should synchronize the Ranger Server instance with the repository.", "No action is required.  This is part of the normal flow."),
    DE_CLASSIFIED_GOVERNED_ASSET_EVENT_RECEIVED("SECURITY-SYNC--0008", OMRSAuditLogRecordSeverity.INFO, "The Security Sync received an event for de-classified governed asset", "The Security Sync instance should synchronize the Ranger Server instance with the repository.", "No action is required.  This is part of the normal flow."),
    DELETED_GOVERNED_ASSET_EVENT_RECEIVED("SECURITY-SYNC--0009", OMRSAuditLogRecordSeverity.INFO, "The Security Sync received an event for deleted governed asset", "The Security Sync instance should synchronize the Ranger Server instance with the repository.", "No action is required.  This is part of the normal flow."),
    SYNCHRONIZE_POLICIES_STARTED("SECURITY-SYNC--0010", OMRSAuditLogRecordSeverity.INFO, "The Security Sync Server started the synchronization of policies from external policies enforcement tool", "The Security Sync instance should synchronize the policies defined in the external policies enforcement tool the repository.", "No action is required.  This is part of the normal flow."),
    SYNCHRONIZE_POLICIES_FINISHED("SECURITY-SYNC--0011", OMRSAuditLogRecordSeverity.INFO, "The Security Sync Server finished the synchronization of policies from external policies enforcement tool", "The Security Sync instance synchronized the policies defined in the external policies enforcement tool the repository.", "No action is required.  This is part of the normal flow.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private SecuritySyncAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }
}

