/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.securitysyncservices.registration;

import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.odpi.openmetadata.securitysyncservices.auditlog.SecuritySyncAuditCode;
import org.odpi.openmetadata.securitysyncservices.ffdc.SecuritySyncErrorCode;
import org.odpi.openmetadata.securitysyncservices.listener.SecuritySyncEventListener;
import org.odpi.openmetadata.securitysyncservices.processor.SecuritySyncEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuritySyncOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(SecuritySyncOperationalServices.class);
    private OpenMetadataTopicConnector inTopic;
    private String localServerName;
    private String localServerType;
    private String localMetadataCollectionName;
    private String localOrganizationName;
    private String localServerUserId;
    private String localServerURL;
    private int maxPageSize;
    private OMRSAuditLog auditLog;

    public SecuritySyncOperationalServices(String localServerName, String localServerType, String localOrganizationName, String localServerUserId, String localServerURL, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.localServerUserId = localServerUserId;
        this.localServerURL = localServerURL;
        this.maxPageSize = maxPageSize;
    }

    public void initialize(SecuritySyncConfig securitySyncConfig, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        if (securitySyncConfig != null) {
            String actionDescription = "initialize";
            this.auditLog = auditLog;
            this.logAudit(SecuritySyncAuditCode.SERVICE_INITIALIZING, "initialize");
            SecuritySyncEventProcessor securitySyncEventProcessor = new SecuritySyncEventProcessor(securitySyncConfig, auditLog);
            this.inTopic = this.getTopicConnector(securitySyncConfig.getSecuritySyncInTopic(), auditLog);
            SecuritySyncEventListener governanceEventListener = new SecuritySyncEventListener(securitySyncEventProcessor);
            this.inTopic.registerListener((OpenMetadataTopicListener)governanceEventListener);
            this.startTopic(this.inTopic, securitySyncConfig.getSecuritySyncInTopicName());
            securitySyncEventProcessor.processExistingGovernedAssetsFromRepository();
            securitySyncEventProcessor.processSecurityServicePolicies();
            securitySyncEventProcessor.syncSecurityPolicies();
            this.logAudit(SecuritySyncAuditCode.SERVICE_INITIALIZED, "initialize");
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, OMRSAuditLog auditLog) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog((AuditLog)auditLog);
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            throw new OMRSConfigErrorException(SecuritySyncErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition("getTopicConnector"), this.getClass().getName(), "getTopicConnector", (Throwable)error);
        }
    }

    public boolean disconnect() {
        try {
            this.inTopic.disconnect();
        }
        catch (ConnectorCheckedException e) {
            log.error("Error disconnecting in topic connector");
        }
        String actionDescription = "shutdown";
        this.logAudit(SecuritySyncAuditCode.SERVICE_SHUTDOWN, "shutdown");
        return false;
    }

    private void startTopic(OpenMetadataTopicConnector topic, String topicName) throws OMAGConfigurationErrorException {
        try {
            topic.start();
        }
        catch (ConnectorCheckedException e) {
            String action = "Unable to initialize the topic connection";
            SecuritySyncAuditCode auditCode = SecuritySyncAuditCode.ERROR_INITIALIZING_SECURITY_SYNC_TOPIC_CONNECTION;
            this.auditLog.logRecord(action, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicName, this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMAGConfigurationErrorException(400, this.getClass().getSimpleName(), action, auditCode.getFormattedLogMessage(new String[0]), auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void logAudit(SecuritySyncAuditCode auditCode, String actionDescription) {
        this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), OMRSAuditLogRecordSeverity.INFO, auditCode.getFormattedLogMessage("Security Sync"), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

