/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.api.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.viewservices.serverauthor.api.properties.PlatformStatus;
import org.odpi.openmetadata.viewservices.serverauthor.api.properties.StoredServer;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Platform {
    private static final long serialVersionUID = 1L;
    private String platformName;
    private String platformDescription;
    private PlatformStatus platformStatus;
    private Set<StoredServer> storedServers = new HashSet<StoredServer>();

    public Platform() {
    }

    public Platform(String platformName, String platformDescription) {
        this.platformName = platformName;
        this.platformDescription = platformDescription;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformDescription() {
        return this.platformDescription;
    }

    public void setPlatformDescription(String platformDescription) {
        this.platformDescription = platformDescription;
    }

    public Set<StoredServer> getStoredServers() {
        return this.storedServers;
    }

    public void setStoredServers(Set<StoredServer> storedServers) {
        this.storedServers = storedServers;
    }

    public void addStoredServer(StoredServer storedServer) {
        this.storedServers.add(storedServer);
    }

    public PlatformStatus getPlatformStatus() {
        return this.platformStatus;
    }

    public void setPlatformStatus(PlatformStatus platformStatus) {
        this.platformStatus = platformStatus;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("platform=");
        sb.append("{");
        sb.append("platformName=").append(this.platformName).append(",");
        sb.append("platformDescription=").append(this.platformDescription).append(",");
        sb.append("platformStatus=").append((Object)this.platformStatus).append(",");
        sb.append("storedServers={");
        for (StoredServer storedServer : this.storedServers) {
            sb.append(storedServer).append(',');
        }
        sb.append('}');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Platform platform = (Platform)o;
        for (StoredServer storedServer : this.storedServers) {
            boolean foundIt = false;
            for (StoredServer platformStoredServer : platform.storedServers) {
                if (Objects.equals(storedServer, platformStoredServer)) {
                    foundIt = true;
                }
                if (foundIt) continue;
                return false;
            }
        }
        return Objects.equals(this.platformName, platform.platformName) && Objects.equals(this.platformDescription, platform.platformDescription) && Objects.equals((Object)this.platformStatus, (Object)platform.platformStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.platformName, this.platformDescription, this.platformStatus, this.storedServers});
    }
}

