/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.api.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerAuthorViewAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMVS-SERVER-AUTHOR-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Server Author View Service (OMVS) is initializing", "The local server is initializing the Server Author OMVS. If the initialization is successful then audit message OMVS-SERVER-AUTHOR-0003 will be issued, if there were errors then they should be shown in the audit log. ", "No action is required. This is part of the normal operation of the Server Author OMVS."),
    SERVICE_INITIALIZED("OMVS-SERVER-AUTHOR-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Server Author View Service (OMVS) is initialized", "The Server Author OMVS has completed initialization. Calls will be accepted by this service, if OMRS is also configured and the view server has been started. ", "No action is required. Once the OMRS is configured and the server is started, Server Author View Service requests can be accepted."),
    SERVICE_SHUTDOWN("OMVS-SERVER-AUTHOR-0003", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Server Author View Service (OMVS) is shutting down", "The local server has requested shutdown of the Server Author OMVS.", "No action is required. The operator should verify that shutdown was intended. This is part of the normal operation of the Server Author OMVS."),
    SERVICE_INSTANCE_FAILURE("OMVS-SERVER-AUTHOR-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The Server Author View Service (OMVS) is unable to initialize a new instance; error message is {0}", "The view service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_TERMINATING("OMVS-SERVER-AUTHOR-0005", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Server Author View Service (OMVS) is shutting down server instance {0}", "The local handler has requested shut down of the Server Author OMVS.", "No action is required. This is part of the normal operation of the service."),
    UNEXPECTED_EXCEPTION("OMVS-SERVER-AUTHOR-0006", OMRSAuditLogRecordSeverity.EXCEPTION, "The Open Metadata Service has generated an unexpected {0} exception during method {1}.  The message was: {2}", "The request returned an Exception.", "This is probably a logic error. Review the stack trace to identify where the error occurred and work to resolve the cause.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private ServerAuthorViewAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ServerAuthorViewAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "', messageDefinition=" + this.getMessageDefinition() + "}";
    }

    static {
        log = LoggerFactory.getLogger(ServerAuthorViewAuditCode.class);
    }
}

