/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.api.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.viewservices.serverauthor.api.properties.PlatformStatus;
import org.odpi.openmetadata.viewservices.serverauthor.api.properties.StoredServer;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Platform {
    private static final long serialVersionUID = 1L;
    private String platformName;
    private String platformDescription;
    private PlatformStatus platformStatus;
    private Set<StoredServer> storedServers = new HashSet<StoredServer>();
    private List<RegisteredOMAGService> accessServices;
    private List<RegisteredOMAGService> engineServices;
    private List<RegisteredOMAGService> integrationServices;
    private List<RegisteredOMAGService> viewServices;

    public Platform() {
    }

    public Platform(String platformName, String platformDescription) {
        this.platformName = platformName;
        this.platformDescription = platformDescription;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformDescription() {
        return this.platformDescription;
    }

    public void setPlatformDescription(String platformDescription) {
        this.platformDescription = platformDescription;
    }

    public Set<StoredServer> getStoredServers() {
        return this.storedServers;
    }

    public void setStoredServers(Set<StoredServer> storedServers) {
        this.storedServers = storedServers;
    }

    public List<RegisteredOMAGService> getAccessServices() {
        return this.accessServices;
    }

    public void setAccessServices(List<RegisteredOMAGService> accessServices) {
        this.accessServices = accessServices;
    }

    public List<RegisteredOMAGService> getEngineServices() {
        return this.engineServices;
    }

    public void setEngineServices(List<RegisteredOMAGService> engineServices) {
        this.engineServices = engineServices;
    }

    public List<RegisteredOMAGService> getIntegrationServices() {
        return this.integrationServices;
    }

    public void setIntegrationServices(List<RegisteredOMAGService> integrationServices) {
        this.integrationServices = integrationServices;
    }

    public List<RegisteredOMAGService> getViewServices() {
        return this.viewServices;
    }

    public void setViewServices(List<RegisteredOMAGService> viewServices) {
        this.viewServices = viewServices;
    }

    public void addStoredServer(StoredServer storedServer) {
        this.storedServers.add(storedServer);
    }

    public PlatformStatus getPlatformStatus() {
        return this.platformStatus;
    }

    public void setPlatformStatus(PlatformStatus platformStatus) {
        this.platformStatus = platformStatus;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("platform=");
        sb.append("{");
        sb.append("platformName=").append(this.platformName).append(",");
        sb.append("platformDescription=").append(this.platformDescription).append(",");
        sb.append("platformStatus=").append((Object)this.platformStatus).append(",");
        sb.append("storedServers=[");
        if (this.storedServers != null && this.storedServers.size() > 0) {
            for (StoredServer storedServer : this.storedServers) {
                sb.append(storedServer).append(',');
            }
        }
        sb.append(']');
        sb.append("accessServices=[");
        if (this.accessServices != null && this.accessServices.size() > 0) {
            for (RegisteredOMAGService registeredOMAGService : this.accessServices) {
                sb.append(registeredOMAGService).append(',');
            }
        }
        sb.append('[');
        sb.append("viewServices=[");
        if (this.viewServices != null && this.viewServices.size() > 0) {
            for (RegisteredOMAGService registeredOMAGService : this.viewServices) {
                sb.append(registeredOMAGService).append(',');
            }
        }
        sb.append(']');
        sb.append("integrationServices=[");
        if (this.integrationServices != null && this.integrationServices.size() > 0) {
            for (RegisteredOMAGService registeredOMAGService : this.integrationServices) {
                sb.append(registeredOMAGService).append(',');
            }
        }
        sb.append(']');
        sb.append("engineServices=[");
        if (this.engineServices != null && this.engineServices.size() > 0) {
            for (RegisteredOMAGService registeredOMAGService : this.engineServices) {
                sb.append(registeredOMAGService).append(',');
            }
        }
        sb.append(']');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        boolean foundIt;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Platform platform = (Platform)o;
        for (StoredServer storedServer : this.storedServers) {
            foundIt = false;
            for (StoredServer platformStoredServer : platform.storedServers) {
                if (Objects.equals(storedServer, platformStoredServer)) {
                    foundIt = true;
                }
                if (foundIt) continue;
                return false;
            }
        }
        for (RegisteredOMAGService registeredOMAGService : this.accessServices) {
            foundIt = false;
            for (RegisteredOMAGService platformRegisteredOMAGService : platform.accessServices) {
                if (Objects.equals(registeredOMAGService, platformRegisteredOMAGService)) {
                    foundIt = true;
                }
                if (foundIt) continue;
                return false;
            }
        }
        for (RegisteredOMAGService registeredOMAGService : this.engineServices) {
            foundIt = false;
            for (RegisteredOMAGService platformRegisteredOMAGService : platform.engineServices) {
                if (Objects.equals(registeredOMAGService, platformRegisteredOMAGService)) {
                    foundIt = true;
                }
                if (foundIt) continue;
                return false;
            }
        }
        for (RegisteredOMAGService registeredOMAGService : this.integrationServices) {
            foundIt = false;
            for (RegisteredOMAGService platformRegisteredOMAGService : platform.integrationServices) {
                if (Objects.equals(registeredOMAGService, platformRegisteredOMAGService)) {
                    foundIt = true;
                }
                if (foundIt) continue;
                return false;
            }
        }
        for (RegisteredOMAGService registeredOMAGService : this.viewServices) {
            foundIt = false;
            for (RegisteredOMAGService platformRegisteredOMAGService : platform.viewServices) {
                if (Objects.equals(registeredOMAGService, platformRegisteredOMAGService)) {
                    foundIt = true;
                }
                if (foundIt) continue;
                return false;
            }
        }
        return Objects.equals(this.platformName, platform.platformName) && Objects.equals(this.platformDescription, platform.platformDescription) && Objects.equals((Object)this.platformStatus, (Object)platform.platformStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.platformName, this.platformDescription, this.platformStatus, this.storedServers, this.accessServices, this.viewServices, this.integrationServices, this.engineServices});
    }
}

