/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.api.ffdc;

import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorViewErrorCode;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorViewServiceException;

public class ServerAuthorExceptionHandler {
    public static void captureCheckedException(FFDCResponse response, OCFCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        if (error.getReportedCaughtException() != null) {
            response.setExceptionCausedBy(error.getReportedCaughtException().getClass().getName());
        }
        response.setActionDescription(error.getReportingActionDescription());
        String fullErrorMessage = error.getReportedErrorMessage();
        String errorMessageId = error.getReportedErrorMessageId();
        String trimmedErrorMessage = fullErrorMessage.substring(errorMessageId.length() + 1);
        response.setExceptionErrorMessage(trimmedErrorMessage);
        response.setExceptionErrorMessageId(error.getReportedErrorMessageId());
        response.setExceptionErrorMessageParameters(error.getReportedErrorMessageParameters());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(null);
    }

    public static ServerAuthorViewServiceException mapToUserNotAuthorizedException(String className, String methodName) {
        return new ServerAuthorViewServiceException(ServerAuthorViewErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(), className, methodName);
    }

    public static ServerAuthorViewServiceException mapOMAGInvalidParameterException(String className, String methodName, OMAGInvalidParameterException omagException) {
        String parameterName = omagException.getReportedErrorMessageParameters()[0];
        return new ServerAuthorViewServiceException(ServerAuthorViewErrorCode.INVALID_PARAMETER.getMessageDefinition(methodName, parameterName), className, methodName);
    }

    public static ServerAuthorViewServiceException mapOMAGConfigurationErrorException(String className, String methodName, OMAGConfigurationErrorException error) {
        return new ServerAuthorViewServiceException(ServerAuthorViewErrorCode.CONFIG_ERROR.getMessageDefinition(methodName), className, methodName);
    }

    public static ServerAuthorViewServiceException mapOCFInvalidParameterException(String className, String methodName, InvalidParameterException error) {
        String parameterName = error.getReportedErrorMessageParameters()[0];
        return new ServerAuthorViewServiceException(ServerAuthorViewErrorCode.INVALID_PARAMETER.getMessageDefinition(methodName, parameterName), className, methodName);
    }

    public static ServerAuthorViewServiceException mapOCFPropertyServerError(String className, String methodName, PropertyServerException error) {
        return new ServerAuthorViewServiceException(ServerAuthorViewErrorCode.INVALID_CONFIG_PROPERTY.getMessageDefinition(methodName), className, methodName);
    }
}

