/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.viewservices.serverauthor.api.properties;

/**
 * The status of the platform for the Server Author View.
 */
public enum PlatformStatus {

    UNKNOWN                 (0,  "<Unknown>",               "Unknown platform status."),
    ACTIVE                  (1,  "Active",                  "The platform is active."),
    NOT_CONTACTABLE         (2,  "Not contactable",         "The platform is not contactable."),
    OTHER                   (99, "Other",                   "The platform has some other status.");

    private final int    ordinal;
    private final String name;
    private final String description;


    /**
     * Default constructor sets up the specific values for an enum instance.
     *
     * @param ordinal int enum value ordinal
     * @param name String name
     * @param description String description
     */
    PlatformStatus(int     ordinal,
                   String  name,
                   String  description)
    {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }


    /**
     * Return the numerical value for the enum.
     *
     * @return int enum value ordinal
     */
    public int getOrdinal() { return ordinal; }


    /**
     * Return the descriptive name for the enum.
     *
     * @return String name
     */
    public String getName() { return name; }


    /**
     * Return the description for the enum.
     *
     * @return String description
     */
    public String getDescription() { return description; }


    /**
     * toString() JSON-style
     *
     * @return string description
     */
    @Override
    public String toString()
    {
        return "InstanceStatus{" +
                "ordinal=" + ordinal +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                '}';
    }
}
