/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.api.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ResourceEndpoint {
    private String resourceCategory;
    private String resourceDescription;
    private String resourceRootURL;
    private String serverName;
    private String platformName;
    private String serverInstanceName;

    public ResourceEndpoint() {
    }

    public ResourceEndpoint(String resourceCategory, String platformName, String resourceDescription, String resourceRootURL, String serverName, String serverInstanceName) {
        this.resourceCategory = resourceCategory;
        this.resourceDescription = resourceDescription;
        this.resourceRootURL = resourceRootURL;
        this.serverName = serverName;
        this.platformName = platformName;
        this.serverInstanceName = serverInstanceName;
    }

    public ResourceEndpoint(ResourceEndpointConfig cfg) {
        this.resourceCategory = cfg.getResourceCategory();
        this.resourceDescription = cfg.getDescription();
        this.resourceRootURL = cfg.getPlatformRootURL();
        this.serverName = cfg.getServerName();
        this.platformName = cfg.getPlatformName();
        this.serverInstanceName = cfg.getServerInstanceName();
    }

    public String getResourceCategory() {
        return this.resourceCategory;
    }

    public void setResourceCategory(String resourceCategory) {
        this.resourceCategory = resourceCategory;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public String getResourceRootURL() {
        return this.resourceRootURL;
    }

    public void setResourceRootURL(String resourceRootURL) {
        this.resourceRootURL = resourceRootURL;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getServerInstanceName() {
        return this.serverInstanceName;
    }

    public void setServerInstanceName(String serverInstanceName) {
        this.serverInstanceName = serverInstanceName;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("resourceEndPoint=");
        sb.append("{");
        sb.append("resourceCategory=").append(this.resourceCategory).append(",");
        sb.append("resourceDescription=").append(this.resourceDescription).append(",");
        sb.append("resourceRootURL=").append(this.resourceRootURL).append(",");
        sb.append("serverName=").append(this.serverName).append(",");
        sb.append("platformName=").append(this.platformName).append(",");
        sb.append("serverInstanceName=").append(this.serverInstanceName).append(",");
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceEndpoint resourceEndPoint = (ResourceEndpoint)o;
        return Objects.equals(this.resourceCategory, resourceEndPoint.resourceCategory) && Objects.equals(this.resourceDescription, resourceEndPoint.resourceDescription) && Objects.equals(this.resourceRootURL, resourceEndPoint.resourceRootURL) && Objects.equals(this.serverName, resourceEndPoint.serverName) && Objects.equals(this.platformName, resourceEndPoint.platformName) && Objects.equals(this.serverName, resourceEndPoint.resourceRootURL) && Objects.equals(this.serverInstanceName, resourceEndPoint.serverInstanceName);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resourceCategory, this.resourceDescription, this.resourceRootURL, this.platformName, this.serverName, this.serverInstanceName);
    }
}

