/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.client.MetadataAccessPointConfigurationClient;
import org.odpi.openmetadata.adminservices.client.MetadataServerConfigurationClient;
import org.odpi.openmetadata.adminservices.client.OMAGServerConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorExceptionHandler;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorViewErrorCode;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorViewServiceException;
import org.odpi.openmetadata.viewservices.serverauthor.api.properties.ResourceEndpoint;

public class ServerAuthorViewHandler {
    private static final int TRUNCATED_STRING_LENGTH = 24;
    private Map<String, ResourceEndpoint> configuredPlatforms = null;
    private Map<String, ResourceEndpoint> configuredServerInstances = null;
    private String userId = null;
    private String platformURL = null;

    public ServerAuthorViewHandler() {
    }

    public ServerAuthorViewHandler(String localServerUserId, String metadataServerURL, List<ResourceEndpointConfig> resourceEndpoints) {
        this.userId = localServerUserId;
        this.platformURL = metadataServerURL;
        this.configuredPlatforms = new HashMap<String, ResourceEndpoint>();
        this.configuredServerInstances = new HashMap<String, ResourceEndpoint>();
        if (resourceEndpoints != null && !resourceEndpoints.isEmpty()) {
            resourceEndpoints.forEach(res -> {
                String resCategory = res.getResourceCategory();
                ResourceEndpoint rep = new ResourceEndpoint(res);
                String resName = null;
                switch (resCategory) {
                    case "Platform": {
                        resName = res.getPlatformName();
                        this.configuredPlatforms.put(resName, rep);
                        break;
                    }
                }
            });
        }
    }

    public Map<String, List<ResourceEndpoint>> getResourceEndpoints(String userId, String methodName) {
        HashMap<String, List<ResourceEndpoint>> returnMap = new HashMap<String, List<ResourceEndpoint>>();
        ArrayList<ResourceEndpoint> platformList = null;
        ArrayList<ResourceEndpoint> serverList = null;
        if (!this.configuredPlatforms.isEmpty()) {
            platformList = new ArrayList<ResourceEndpoint>();
            platformList.addAll(this.configuredPlatforms.values());
        }
        if (!this.configuredServerInstances.isEmpty()) {
            serverList = new ArrayList<ResourceEndpoint>();
            serverList.addAll(this.configuredServerInstances.values());
        }
        returnMap.put("platformList", platformList);
        return returnMap;
    }

    private String resolvePlatformRootURL(String platformName, String methodName) throws InvalidParameterException {
        ResourceEndpoint resource;
        String platformRootURL = null;
        if (platformName != null && (resource = this.configuredPlatforms.get(platformName)) != null) {
            platformRootURL = resource.getResourceRootURL();
        }
        if (platformName == null || platformRootURL == null) {
            throw new InvalidParameterException(ServerAuthorViewErrorCode.VIEW_SERVICE_NULL_PLATFORM_NAME.getMessageDefinition(), this.getClass().getName(), methodName, "platformName");
        }
        return platformRootURL;
    }

    public void setInMemLocalRepository(String className, String methodName, String serverToBeConfiguredName) throws ServerAuthorViewServiceException {
        try {
            MetadataServerConfigurationClient configurationClient = new MetadataServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            configurationClient.setInMemLocalRepository();
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void setGraphLocalRepository(String className, String methodName, String serverToBeConfiguredName, Map<String, Object> storageProperties) throws ServerAuthorViewServiceException {
        try {
            MetadataServerConfigurationClient configurationClient = new MetadataServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            configurationClient.setGraphLocalRepository(storageProperties);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void setReadOnlyLocalRepository(String className, String methodName, String serverToBeConfiguredName) throws ServerAuthorViewServiceException {
        try {
            MetadataServerConfigurationClient configurationClient = new MetadataServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            configurationClient.setReadOnlyLocalRepository();
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public OMAGServerConfig getStoredConfiguration(String className, String methodName, String serverToBeRetrievedName) throws ServerAuthorViewServiceException {
        OMAGServerConfig config = null;
        try {
            OMAGServerConfigurationClient adminServicesClient = new OMAGServerConfigurationClient(this.userId, serverToBeRetrievedName, this.platformURL);
            config = adminServicesClient.getOMAGServerConfig();
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
        return config;
    }

    public void deployOMAGServerConfig(String className, String methodName, String destinationPlatformName, String serverToBeDeployedName) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient adminServicesClient = new OMAGServerConfigurationClient(this.userId, serverToBeDeployedName, this.platformURL);
            adminServicesClient.deployOMAGServerConfig(this.platformURL);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void setOMAGServerConfig(String className, String methodName, String serverToBeConfiguredName, OMAGServerConfig omagServerConfig) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient adminServicesClient = new OMAGServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            adminServicesClient.setOMAGServerConfig(omagServerConfig);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void configureAccessService(String className, String methodName, String serverToBeConfiguredName, String serviceURLMarker, Map<String, Object> accessServiceOptions) throws ServerAuthorViewServiceException {
        try {
            MetadataAccessPointConfigurationClient client = new MetadataAccessPointConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            if (accessServiceOptions == null) {
                accessServiceOptions = new HashMap<String, Object>();
            }
            client.configureAccessService(serviceURLMarker, accessServiceOptions);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void configureAllAccessServices(String className, String methodName, String serverToBeConfiguredName, Map<String, Object> accessServiceOptions) throws ServerAuthorViewServiceException {
        try {
            MetadataAccessPointConfigurationClient client = new MetadataAccessPointConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            if (accessServiceOptions == null) {
                accessServiceOptions = new HashMap<String, Object>();
            }
            client.configureAllAccessServices(accessServiceOptions);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void setEnterpriseAccessConfig(String className, String methodName, String serverToBeConfiguredName, EnterpriseAccessConfig enterpriseAccessConfig) throws ServerAuthorViewServiceException {
        try {
            MetadataAccessPointConfigurationClient client = new MetadataAccessPointConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            client.setEnterpriseAccessConfig(enterpriseAccessConfig);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void setEventBus(String className, String methodName, String serverToBeConfiguredName, String connectorProvider, String topicURLRoot, Map<String, Object> configurationProperties) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            client.setEventBus(connectorProvider, topicURLRoot, configurationProperties);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void setDefaultAuditLog(String className, String methodName, String serverToBeConfiguredName) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            client.setDefaultAuditLog();
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void addConsoleAuditLogDestination(String className, String methodName, String serverToBeConfiguredName, List<String> supportedSeverities) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            client.addConsoleAuditLogDestination(supportedSeverities);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void addSLF4JAuditLogDestination(String className, String methodName, String serverToBeConfiguredName, List<String> supportedSeverities) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            client.addSLF4JAuditLogDestination(supportedSeverities);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void addFileAuditLogDestination(String className, String methodName, String serverToBeConfiguredName, List<String> supportedSeverities) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            client.addFileAuditLogDestination(supportedSeverities);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void addEventTopicAuditLogDestination(String className, String methodName, String serverToBeConfiguredName, List<String> supportedSeverities) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            client.addEventTopicAuditLogDestination(supportedSeverities);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public void addAuditLogDestination(String className, String methodName, String serverToBeConfiguredName, Connection connection) throws ServerAuthorViewServiceException {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.userId, serverToBeConfiguredName, this.platformURL);
            client.addAuditLogDestination(connection);
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
    }

    public OMAGServerConfig getActiveConfiguration(String className, String methodName, String serverToRetrieveName) throws ServerAuthorViewServiceException {
        OMAGServerConfig config = null;
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.userId, serverToRetrieveName, this.platformURL);
            config = client.getOMAGServerInstanceConfig();
        }
        catch (OMAGNotAuthorizedException error) {
            throw ServerAuthorExceptionHandler.mapOMAGUserNotAuthorizedException((String)className, (String)methodName, (OMAGNotAuthorizedException)error);
        }
        catch (OMAGInvalidParameterException error) {
            throw ServerAuthorExceptionHandler.mapOMAGInvalidParameterException((String)className, (String)methodName, (OMAGInvalidParameterException)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw ServerAuthorExceptionHandler.mapOMAGConfigurationErrorException((String)className, (String)methodName, (OMAGConfigurationErrorException)error);
        }
        return config;
    }

    public void activateWithStoredConfig(String className, String methodName, String destinationPlatformName, String serverToBeActivatedName) {
    }

    public void deactivateServerPermanently(String className, String methodName, String destinationPlatformName, String serverToBeDeactivatedName) {
    }

    public void deactivateServerTemporarily(String className, String methodName, String destinationPlatformName, String serverToBeDeactivatedName) {
    }
}

