/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.services;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorExceptionHandler;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorViewServiceException;
import org.odpi.openmetadata.viewservices.serverauthor.api.properties.ResourceEndpoint;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.ServerAuthorConfigurationResponse;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.ServerAuthorPlatformsResponse;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.ServerAuthorResourceEndpointListResponse;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.SupportedAuditLogSeveritiesResponse;
import org.odpi.openmetadata.viewservices.serverauthor.handlers.ServerAuthorViewHandler;
import org.odpi.openmetadata.viewservices.serverauthor.initialization.ServerAuthorViewInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAuthorViewRESTServices {
    private static final String className = ServerAuthorViewRESTServices.class.getName();
    private static final Logger log = LoggerFactory.getLogger(ServerAuthorViewRESTServices.class);
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    protected static ServerAuthorViewInstanceHandler instanceHandler = new ServerAuthorViewInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ServerAuthorViewRESTServices.class), instanceHandler.getServiceName());

    public ServerAuthorResourceEndpointListResponse getResourceEndpointList(String serverName, String userId) {
        String methodName = "getResourceEndpointList";
        ServerAuthorResourceEndpointListResponse response = new ServerAuthorResourceEndpointListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceEndpointList");
            ServerAuthorViewHandler handler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "getResourceEndpointList");
            Map<String, List<ResourceEndpoint>> lists = handler.getResourceEndpoints();
            List<ResourceEndpoint> platformList = null;
            if (lists != null) {
                platformList = lists.get("platformList");
            }
            response.setPlatformList(platformList);
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getResourceEndpointList", auditLog);
        }
        log.debug("Returning from method: getResourceEndpointList with response: " + response.toString());
        return response;
    }

    public FFDCResponseBase setInMemLocalRepository(String userId, String serverName, String serverToBeConfiguredName) {
        String methodName = "setInMemLocalRepository";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setInMemLocalRepository");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setInMemLocalRepository");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "setInMemLocalRepository");
            serverAuthorViewHandler.setInMemLocalRepository(className, "setInMemLocalRepository", serverToBeConfiguredName);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "setInMemLocalRepository", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FFDCResponseBase setGraphLocalRepository(String userId, String serverName, String serverToBeConfiguredName, Map<String, Object> storageProperties) {
        String methodName = "setGraphLocalRepository";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGraphLocalRepository");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGraphLocalRepository");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "setGraphLocalRepository");
            serverAuthorViewHandler.setGraphLocalRepository(className, "setGraphLocalRepository", serverToBeConfiguredName, storageProperties);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "setGraphLocalRepository", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FFDCResponseBase setReadOnlyLocalRepository(String userId, String serverName, String serverToBeConfiguredName) {
        String methodName = "setGraphLocalRepository";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGraphLocalRepository");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGraphLocalRepository");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "setGraphLocalRepository");
            serverAuthorViewHandler.setReadOnlyLocalRepository(className, "setGraphLocalRepository", serverToBeConfiguredName);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "setGraphLocalRepository", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse getStoredConfiguration(String userId, String serverName, String serverToBeRetrievedName) {
        String methodName = "getStoredConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStoredConfiguration");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStoredConfiguration");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "getStoredConfiguration");
            OMAGServerConfig config = serverAuthorViewHandler.getStoredConfiguration(className, "getStoredConfiguration", serverToBeRetrievedName);
            response = new ServerAuthorConfigurationResponse();
            response.setOmagServerConfig(config);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getStoredConfiguration", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse deployOMAGServerConfig(String userId, String serverName, String destinationPlatformName, String serverToBeConfiguredName) {
        String methodName = "deployOMAGServerConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deployOMAGServerConfig");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deployOMAGServerConfig");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "deployOMAGServerConfig");
            serverAuthorViewHandler.deployOMAGServerConfig(className, "deployOMAGServerConfig", destinationPlatformName, serverToBeConfiguredName);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "deployOMAGServerConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse setOMAGServerConfig(String userId, String serverName, String serverToBeConfiguredName, OMAGServerConfig omagServerConfig) {
        String methodName = "setOMAGServerConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setOMAGServerConfig");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setOMAGServerConfig");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "setOMAGServerConfig");
            serverAuthorViewHandler.setOMAGServerConfig(className, "setOMAGServerConfig", serverToBeConfiguredName, omagServerConfig);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse configureAccessService(String userId, String serverName, String serverToBeConfiguredName, String serviceURLMarker, Map<String, Object> accessServiceOptions) {
        String methodName = "configureAccessService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAccessService");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "configureAccessService");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "configureAccessService");
            serverAuthorViewHandler.configureAccessService(className, "configureAccessService", serverToBeConfiguredName, serviceURLMarker, accessServiceOptions);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "configureAccessService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse configureAllAccessServices(String userId, String serverName, String serverToBeConfiguredName, Map<String, Object> accessServiceOptions) {
        String methodName = "configureAllAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAllAccessServices");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "configureAllAccessServices");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "configureAllAccessServices");
            serverAuthorViewHandler.configureAllAccessServices(className, "configureAllAccessServices", serverToBeConfiguredName, accessServiceOptions);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "configureAllAccessServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse setEnterpriseAccessConfig(String userId, String serverName, String serverToBeConfiguredName, EnterpriseAccessConfig enterpriseAccessConfig) {
        String methodName = "setEnterpriseAccessConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setEnterpriseAccessConfig");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setEnterpriseAccessConfig");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "setEnterpriseAccessConfig");
            serverAuthorViewHandler.setEnterpriseAccessConfig(className, "setEnterpriseAccessConfig", serverToBeConfiguredName, enterpriseAccessConfig);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "setEnterpriseAccessConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse setEventBus(String userId, String serverName, String serverToBeConfiguredName, String connectorProvider, String topicURLRoot, Map<String, Object> configurationProperties) {
        String methodName = "setEventBus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setEventBus");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setEventBus");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "setEventBus");
            serverAuthorViewHandler.setEventBus(className, "setEventBus", serverToBeConfiguredName, connectorProvider, topicURLRoot, configurationProperties);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "setEventBus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse setDefaultAuditLog(String userId, String serverName, String serverToBeConfiguredName) {
        String methodName = "setDefaultAuditLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setDefaultAuditLog");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setDefaultAuditLog");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "setDefaultAuditLog");
            serverAuthorViewHandler.setDefaultAuditLog(className, "setDefaultAuditLog", serverToBeConfiguredName);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "setDefaultAuditLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse addConsoleAuditLogDestination(String userId, String serverName, String serverToBeConfiguredName, List<String> supportedSeverities) {
        String methodName = "addConsoleAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addConsoleAuditLogDestination");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addConsoleAuditLogDestination");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "addConsoleAuditLogDestination");
            serverAuthorViewHandler.addConsoleAuditLogDestination(className, "addConsoleAuditLogDestination", serverToBeConfiguredName, supportedSeverities);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse addSLF4JAuditLogDestination(String userId, String serverName, String serverToBeConfiguredName, List<String> supportedSeverities) {
        String methodName = "addSLF4JAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSLF4JAuditLogDestination");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSLF4JAuditLogDestination");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "addSLF4JAuditLogDestination");
            serverAuthorViewHandler.addSLF4JAuditLogDestination(className, "addSLF4JAuditLogDestination", serverToBeConfiguredName, supportedSeverities);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "addSLF4JAuditLogDestination", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse addFileAuditLogDestination(String userId, String serverName, String serverToBeConfiguredName, List<String> supportedSeverities) {
        String methodName = "addFileAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addFileAuditLogDestination");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addFileAuditLogDestination");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "addFileAuditLogDestination");
            serverAuthorViewHandler.addFileAuditLogDestination(className, "addFileAuditLogDestination", serverToBeConfiguredName, supportedSeverities);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "addFileAuditLogDestination", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse addEventTopicAuditLogDestination(String userId, String serverName, String serverToBeConfiguredName, List<String> supportedSeverities) {
        String methodName = "addEventTopicAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addEventTopicAuditLogDestination");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addEventTopicAuditLogDestination");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "addEventTopicAuditLogDestination");
            serverAuthorViewHandler.addEventTopicAuditLogDestination(className, "addEventTopicAuditLogDestination", serverToBeConfiguredName, supportedSeverities);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "addEventTopicAuditLogDestination", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse addAuditLogDestination(String userId, String serverName, String serverToBeConfiguredName, Connection connection) {
        String methodName = "addAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAuditLogDestination");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAuditLogDestination");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "addAuditLogDestination");
            serverAuthorViewHandler.addAuditLogDestination(className, "addAuditLogDestination", serverToBeConfiguredName, connection);
            response = this.getStoredConfiguration(userId, serverName, serverToBeConfiguredName);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "addAuditLogDestination", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse activateWithStoredConfig(String userId, String serverName, String destinationPlatformName, String serverToBeActivatedName) {
        String methodName = "activateWithStoredConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "activateWithStoredConfig");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "activateWithStoredConfig");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "activateWithStoredConfig");
            serverAuthorViewHandler.activateWithStoredConfig(className, "activateWithStoredConfig", destinationPlatformName, serverToBeActivatedName);
            OMAGServerConfig config = serverAuthorViewHandler.getActiveConfiguration(className, "activateWithStoredConfig", serverToBeActivatedName);
            response.setOmagServerConfig(config);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "activateWithStoredConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse deactivateTemporarily(String userId, String serverName, String destinationPlatformName, String serverToBeDeactivatedName) {
        String methodName = "deactivateTemporarily";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deactivateTemporarily");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deactivateTemporarily");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "deactivateTemporarily");
            serverAuthorViewHandler.deactivateServerTemporarily(className, "deactivateTemporarily", destinationPlatformName, serverToBeDeactivatedName);
            OMAGServerConfig config = serverAuthorViewHandler.getStoredConfiguration(className, "deactivateTemporarily", serverToBeDeactivatedName);
            response.setOmagServerConfig(config);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "deactivateTemporarily", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SuccessMessageResponse deactivatePermanently(String userId, String serverName, String destinationPlatformName, String serverToBeDeactivatedName) {
        String methodName = "activateWithStoredConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "activateWithStoredConfig");
        SuccessMessageResponse response = new SuccessMessageResponse();
        response.setSuccessMessage("Activate the server");
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "activateWithStoredConfig");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "activateWithStoredConfig");
            serverAuthorViewHandler.deactivateServerPermanently(className, "activateWithStoredConfig", destinationPlatformName, serverToBeDeactivatedName);
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorConfigurationResponse getActiveConfiguration(String userId, String serverName, String destinationPlatformName, String serverToBeConfiguredName) {
        String methodName = "getStoredConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStoredConfiguration");
        ServerAuthorConfigurationResponse response = new ServerAuthorConfigurationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStoredConfiguration");
            ServerAuthorViewHandler serverAuthorViewHandler = instanceHandler.getServerAuthorViewHandler(userId, serverName, "getStoredConfiguration");
            OMAGServerConfig config = serverAuthorViewHandler.getActiveConfiguration(className, "getStoredConfiguration", serverToBeConfiguredName);
            response.setOmagServerConfig(config);
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAuthorPlatformsResponse getKnownPlatforms(String userId, String serverName) {
        String methodName = "getKnownPlatforms";
        if (log.isDebugEnabled()) {
            log.debug("Entering method: " + methodName + " with serverName " + serverName);
        }
        ServerAuthorPlatformsResponse response = new ServerAuthorPlatformsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            ServerAuthorViewHandler handler = instanceHandler.getServerAuthorViewHandler(userId, serverName, methodName);
            response.setPlatforms(handler.getKnownPlatforms(userId, methodName, auditLog));
        }
        catch (ServerAuthorViewServiceException error) {
            ServerAuthorExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)className);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, methodName, auditLog);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning from method: " + methodName + " with response: " + response.toString());
        }
        return response;
    }

    public SupportedAuditLogSeveritiesResponse getAuditLogDestinationSupportedSeverities(String userId, String serverName, String serverToBeConfiguredName) {
        String methodName = " getAuditLogDestinationSupportedSeverities";
        if (log.isDebugEnabled()) {
            log.debug("Entering method: " + methodName + " with serverName " + serverName);
        }
        SupportedAuditLogSeveritiesResponse response = new SupportedAuditLogSeveritiesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            ServerAuthorViewHandler handler = instanceHandler.getServerAuthorViewHandler(userId, serverName, methodName);
            response.setSeverities(handler.getSupportedAuditLogSeverities());
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, methodName, auditLog);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning from method: " + methodName + " with response: " + response.toString());
        }
        return response;
    }

    public VoidResponse addCohortRegistration(String userId, String serverName, String serverToBeConfiguredName, String cohortName) {
        String methodName = "addCohortRegistration";
        if (log.isDebugEnabled()) {
            log.debug("Entering method: " + methodName + " with serverName " + serverName + " server To Be Configured Name " + serverToBeConfiguredName);
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            ServerAuthorViewHandler handler = instanceHandler.getServerAuthorViewHandler(userId, serverName, methodName);
            handler.addCohortRegistration(serverToBeConfiguredName, cohortName);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, methodName, auditLog);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning from method: " + methodName + " with response: " + response.toString());
        }
        return response;
    }
}

