/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.admin;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.ViewServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorViewAuditCode;
import org.odpi.openmetadata.viewservices.serverauthor.api.ffdc.ServerAuthorViewErrorCode;
import org.odpi.openmetadata.viewservices.serverauthor.initialization.ServerAuthorViewServicesInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAuthorViewAdmin
extends ViewServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(ServerAuthorViewAdmin.class);
    protected String resourceEndpointsPropertyName = "resourceEndpoints";
    private AuditLog auditLog = null;
    private String serverUserName = null;
    private ServerAuthorViewServicesInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfig, AuditLog auditLog, String serverUserName, int maxPageSize) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", ServerAuthorViewAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        if (log.isDebugEnabled()) {
            log.debug("==> Method: initialize");
        }
        IntegrationViewServiceConfig integrationViewServiceConfig = null;
        if (!(viewServiceConfig instanceof IntegrationViewServiceConfig)) {
            this.logBadConfiguration(viewServiceConfig.getViewServiceName(), "viewServiceConfig", viewServiceConfig.toString(), auditLog, "initialize");
            return;
        }
        integrationViewServiceConfig = (IntegrationViewServiceConfig)viewServiceConfig;
        String viewServiceFullName = viewServiceConfig.getViewServiceName();
        try {
            List<ResourceEndpointConfig> resourceEndpoints = this.extractResourceEndpoints(integrationViewServiceConfig.getResourceEndpoints(), viewServiceFullName, auditLog);
            this.instance = new ServerAuthorViewServicesInstance(serverName, auditLog, serverUserName, maxPageSize, viewServiceConfig.getOMAGServerPlatformRootURL(), resourceEndpoints);
            this.serverUserName = serverUserName;
            this.serverName = serverName;
            auditLog.logMessage("initialize", ServerAuthorViewAuditCode.SERVICE_INITIALIZED.getMessageDefinition(), viewServiceConfig.toString());
            if (log.isDebugEnabled()) {
                log.debug("<== Method: initialize");
            }
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditLog.logException("initialize", ServerAuthorViewAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), viewServiceConfig.toString(), error);
            super.throwUnexpectedInitializationException("initialize", ViewServiceDescription.SERVER_AUTHOR.getViewServiceFullName(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        log.debug("==> Method: shutdown");
        this.auditLog.logMessage("shutdown", ServerAuthorViewAuditCode.SERVICE_TERMINATING.getMessageDefinition(new String[]{this.serverName}));
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", ServerAuthorViewAuditCode.SERVICE_SHUTDOWN.getMessageDefinition());
        log.debug("<== Method: shutdown");
    }

    protected List<ResourceEndpointConfig> extractResourceEndpoints(List<ResourceEndpointConfig> resourceEndpoints, String viewServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractResourceEndpoints";
        String parameterName = "resourceEndpoints";
        try {
            if (resourceEndpoints == null) {
                throw new InvalidParameterException(ServerAuthorViewErrorCode.INVALID_CONFIG_PROPERTY.getMessageDefinition(new String[]{"resourceEndpoints"}), ((Object)((Object)this)).getClass().getName(), "extractResourceEndpoints", "resourceEndpoints");
            }
            List<ResourceEndpointConfig> endpointList = resourceEndpoints;
            auditLog.logMessage("extractResourceEndpoints", OMAGAdminAuditCode.RESOURCE_ENDPOINTS.getMessageDefinition(new String[]{viewServiceFullName, endpointList.toString()}));
            return endpointList;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(viewServiceFullName, this.resourceEndpointsPropertyName, resourceEndpoints.toString(), auditLog, "extractResourceEndpoints", error);
            return null;
        }
    }
}

