/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.ServerAuthorConfigurationResponse;
import org.odpi.openmetadata.viewservices.serverauthor.services.ServerAuthorViewRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/server-author/users/{userId}/servers/{serverBeingConfiguredName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/user/configuring-an-omag-server.html"))
public class ConfigViewResource {
    private ServerAuthorViewRESTServices adminAPI = new ServerAuthorViewRESTServices();

    @GetMapping(path={"/configuration"})
    public ServerAuthorConfigurationResponse getStoredConfiguration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverBeingConfiguredName) {
        return this.adminAPI.getStoredConfiguration(userId, serverName, serverBeingConfiguredName);
    }

    @PostMapping(path={"/configuration"})
    public ServerAuthorConfigurationResponse setOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverBeingConfiguredName, @RequestBody OMAGServerConfig omagServerConfig) {
        return this.adminAPI.setOMAGServerConfig(userId, serverName, serverBeingConfiguredName, omagServerConfig);
    }

    @PostMapping(path={"/configuration/deploy"})
    public ServerAuthorConfigurationResponse deployOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String destinationPlatformName, @PathVariable String serverBeingConfiguredName) {
        return this.adminAPI.deployOMAGServerConfig(userId, serverName, destinationPlatformName, serverBeingConfiguredName);
    }
}

