/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.ServerAuthorConfigurationResponse;
import org.odpi.openmetadata.viewservices.serverauthor.services.ServerAuthorViewRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/server-author/users/{userId}/servers/{serverToBeConfiguredName}"})
@Tag(name="Administration Services - Operational", description="The operational administration services support the management of OMAG Server instances.  This includes starting and stopping the servers as well as querying and changing their operational state.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/operations/operating-omag-server/"))
public class OperationalServicesViewResource {
    private ServerAuthorViewRESTServices operationalServices = new ServerAuthorViewRESTServices();

    @PostMapping(path={"/instance"})
    @Operation(summary="Activate server with stored configuration document", description="Activate the named OMAG server using the appropriate configuration document found in the configuration store.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria-project.org/concepts/configuration-document"))
    public ServerAuthorConfigurationResponse activateWithStoredConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String destinationPlatformName, @PathVariable String serverToBeConfiguredName) {
        return this.operationalServices.activateWithStoredConfig(userId, serverName, destinationPlatformName, serverToBeConfiguredName);
    }

    @DeleteMapping(path={"/instance"})
    @Operation(summary="Shutdown server", description="Temporarily shutdown the named OMAG server.  This server can be restarted as a later time.")
    public ServerAuthorConfigurationResponse deactivateTemporarily(@PathVariable String userId, @PathVariable String serverName, @PathVariable String destinationPlatformName, @PathVariable String serverToBeConfiguredName) {
        return this.operationalServices.deactivateTemporarily(userId, serverName, destinationPlatformName, serverToBeConfiguredName);
    }

    @DeleteMapping(path={""})
    @Operation(summary="Shutdown and delete server", description="Permanently shutdown the named OMAG server and delete its configuration.  The server will also be removed from any open metadata repository cohorts it has registered with.")
    public SuccessMessageResponse deactivatePermanently(@PathVariable String userId, @PathVariable String serverName, @PathVariable String destinationPlatformName, @PathVariable String serverToBeConfiguredName) {
        return this.operationalServices.deactivatePermanently(userId, serverName, destinationPlatformName, serverToBeConfiguredName);
    }

    @GetMapping(path={"/instance/configuration"})
    @Operation(summary="Retrieve active server's running configuration", description="Retrieve the configuration document used to start a running instance of a server. The stored configuration document may have changed since the server was started.  This operation makes it possible to verify the configuration values actually being used in the running server. \n\nNull is returned if the server is not running.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria-project.org/concepts/configuration-document/"))
    public ServerAuthorConfigurationResponse getActiveConfiguration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String destinationPlatformName, @PathVariable String serverToBeConfiguredName) {
        return this.operationalServices.getActiveConfiguration(userId, serverName, destinationPlatformName, serverToBeConfiguredName);
    }
}

