/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.ServerAuthorConfigurationResponse;
import org.odpi.openmetadata.viewservices.serverauthor.services.ServerAuthorViewRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/server-author/users/{userId}/servers/{serverToBeConfiguredName}"})
@Tag(name="Server Author OMVS", description="The Server Author OMVS is for user interfaces supporting the creating and editing of OMAG Server Configuration Documents.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/services/omvs/server-author/overview"))
public class ConfigAccessServicesViewResource {
    private final ServerAuthorViewRESTServices adminAPI = new ServerAuthorViewRESTServices();

    @PostMapping(path={"/access-services/{serviceURLMarker}"})
    public ServerAuthorConfigurationResponse configureAccessService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @PathVariable String serviceURLMarker, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAccessService(userId, serverName, serverToBeConfiguredName, serviceURLMarker, accessServiceOptions);
    }

    @DeleteMapping(path={"/access-services/{serviceURLMarker}"})
    public ServerAuthorConfigurationResponse disableAccessService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.disableAccessService(userId, serverName, serverToBeConfiguredName, serviceURLMarker);
    }

    @PostMapping(path={"/access-services"})
    public ServerAuthorConfigurationResponse configureAllAccessServices(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAllAccessServices(userId, serverName, serverToBeConfiguredName, accessServiceOptions);
    }

    @PostMapping(path={"/enterprise-access/configuration"})
    public ServerAuthorConfigurationResponse setEnterpriseAccessConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody EnterpriseAccessConfig enterpriseAccessConfig) {
        return this.adminAPI.setEnterpriseAccessConfig(userId, serverName, serverToBeConfiguredName, enterpriseAccessConfig);
    }
}

