/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.serverauthor.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.ServerAuthorConfigurationResponse;
import org.odpi.openmetadata.viewservices.serverauthor.api.rest.SupportedAuditLogSeveritiesResponse;
import org.odpi.openmetadata.viewservices.serverauthor.services.ServerAuthorViewRESTServices;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/server-author/users/{userId}/servers/{serverToBeConfiguredName}"})
@Tag(name="Server Author OMVS", description="The Server Author OMVS is for user interfaces supporting the creating and editing of OMAG Server Configuration Documents.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/services/omvs/server-author/overview"))
class ConfigRepositoryServicesViewResource {
    private final ServerAuthorViewRESTServices serverAPI = new ServerAuthorViewRESTServices();

    ConfigRepositoryServicesViewResource() {
    }

    @PostMapping(path={"/local-repository/mode/in-memory-repository"})
    public FFDCResponseBase setInMemLocalRepository(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.serverAPI.setInMemLocalRepository(userId, serverName, serverToBeConfiguredName);
    }

    @PostMapping(path={"/local-repository/mode/local-graph-repository"})
    public FFDCResponseBase setGraphLocalRepository(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody @Nullable Map<String, Object> storageProperties) {
        return this.serverAPI.setGraphLocalRepository(userId, serverName, serverToBeConfiguredName, storageProperties);
    }

    @PostMapping(path={"/local-repository/mode/read-only-repository"})
    public FFDCResponseBase setGraphLocalRepository(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName) {
        return this.serverAPI.setReadOnlyLocalRepository(userId, serverName, serverToBeConfiguredName);
    }

    @PostMapping(path={"/local-repository/mode/plugin-repository/connection"})
    public FFDCResponseBase setPluginRepositoryConnection(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody Connection connection) {
        return this.serverAPI.setPluginRepositoryConnection(userId, serverName, serverToBeConfiguredName, connection);
    }

    @PostMapping(path={"/audit-log-destinations/default"})
    public ServerAuthorConfigurationResponse setDefaultAuditLog(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName) {
        return this.serverAPI.setDefaultAuditLog(userId, serverName, serverToBeConfiguredName);
    }

    @PostMapping(path={"/audit-log-destinations/console"})
    public ServerAuthorConfigurationResponse addConsoleAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody List<String> supportedSeverities) {
        return this.serverAPI.addConsoleAuditLogDestination(userId, serverName, serverToBeConfiguredName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/slf4j"})
    public ServerAuthorConfigurationResponse addSLF4JAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody List<String> supportedSeverities) {
        return this.serverAPI.addSLF4JAuditLogDestination(userId, serverName, serverToBeConfiguredName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/files"})
    public ServerAuthorConfigurationResponse addFileAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody List<String> supportedSeverities) {
        return this.serverAPI.addFileAuditLogDestination(userId, serverName, serverToBeConfiguredName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/event-topic"})
    public ServerAuthorConfigurationResponse addEventTopicAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody List<String> supportedSeverities) {
        return this.serverAPI.addEventTopicAuditLogDestination(userId, serverName, serverToBeConfiguredName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/connection"})
    public ServerAuthorConfigurationResponse addAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @RequestBody Connection connection) {
        return this.serverAPI.addAuditLogDestination(userId, serverName, serverToBeConfiguredName, connection);
    }

    @PutMapping(path={"/audit-log-destinations/connection/{auditLogDestinationName}"})
    public ServerAuthorConfigurationResponse updateAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @PathVariable String auditLogDestinationName, @RequestBody Connection auditLogDestination) {
        return this.serverAPI.updateAuditLogDestination(userId, serverName, serverToBeConfiguredName, auditLogDestinationName, auditLogDestination);
    }

    @DeleteMapping(path={"/audit-log-destinations/connection/{auditLogDestinationName}"})
    public ServerAuthorConfigurationResponse deleteAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @PathVariable String auditLogDestinationName) {
        return this.serverAPI.deleteAuditLogDestination(userId, serverName, serverToBeConfiguredName, auditLogDestinationName);
    }

    @GetMapping(path={"/audit-log-destinations"})
    public SupportedAuditLogSeveritiesResponse getAuditLogDestinationSupportedSeverities(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName) {
        return this.serverAPI.getAuditLogDestinationSupportedSeverities(userId, serverName, serverToBeConfiguredName);
    }

    @DeleteMapping(path={"/audit-log-destinations"})
    public FFDCResponseBase deleteAuditLogDestinationSupportedSeverities(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName) {
        return this.serverAPI.clearAuditLogDestinations(userId, serverName, serverToBeConfiguredName);
    }

    @PostMapping(path={"/cohorts/{cohortName}"})
    public VoidResponse addCohortRegistration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @PathVariable String cohortName) {
        return this.serverAPI.addCohortRegistration(userId, serverName, serverToBeConfiguredName, cohortName);
    }

    @DeleteMapping(path={"/cohorts/{cohortName}"})
    public VoidResponse removeCohortRegistration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serverToBeConfiguredName, @PathVariable String cohortName) {
        return this.serverAPI.removeCohortRegistration(userId, serverName, serverToBeConfiguredName, cohortName);
    }
}

