/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serverchassis.springboot;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.Filter;
import org.odpi.openmetadata.adminservices.OMAGServerOperationalServices;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.http.HttpRequestHeadersFilter;
import org.odpi.openmetadata.serverchassis.springboot.StartupFailEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@SpringBootApplication(scanBasePackages={"${scan.packages}"})
@OpenAPIDefinition(info=@Info(title="Egeria's Open Metadata and Governance (OMAG) Server Platform", version="3.14", description="The OMAG Server Platform provides a runtime process and platform for Open Metadata and Governance (OMAG) Services.\n\nThe OMAG services are configured and activated in OMAG Servers using the Administration Services.\nThe configuration operations of the admin services create configuration documents, one for each OMAG Server.  Inside a configuration document is the definition of which OMAG services to activate in the server. These include the repository services (any type of server), the access services (for metadata access points and metadata servers), governance services (for governance servers) and view services (for view servers).  Once a configuration document is defined, the OMAG Server can be started and stopped multiple times by the admin services server instance operations.  \n\nThe OMAG Server Platform also supports platform services to query details of the servers running on the platform.\n\nThe OMAG Server Platform can host multiple OMAG servers at any one time. Each OMAG server is isolated within the server platform and so the OMAG server platform can be used to support multi-tenant operation for a cloud service, or host a variety of different OMAG Servers needed at a particular location.\n\nNOTE: many REST APIS are not guaranteed to be backward-compatible from release to release since they have supported Java clients.  REST APIs may be used for development, testing, evaluation.  Click on the documentation for each module to discover more ...", license=@License(name="Apache 2.0 License", url="https://www.apache.org/licenses/LICENSE-2.0"), contact=@Contact(url="https://egeria-project.org", name="Egeria Project", email="egeria-technical-discuss@lists.lfaidata.foundation")), externalDocs=@ExternalDocumentation(description="OMAG Server Platform documentation", url="https://egeria-project.org/concepts/omag-server-platform/"))
@Configuration
public class OMAGServerPlatform {
    @Value(value="${strict.ssl}")
    Boolean strictSSL;
    @Value(value="${startup.user}")
    String sysUser;
    @Value(value="${startup.server.list}")
    String startupServers;
    @Value(value="${header.name.list}")
    List<String> headerNames;
    @Autowired
    private Environment env;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean triggeredRuntimeHalt = false;
    private String startupMessage = "";
    private OMAGServerOperationalServices operationalServices = new OMAGServerOperationalServices();
    private static final Logger log = LoggerFactory.getLogger(OMAGServerPlatform.class);

    public static void main(String[] args) {
        SpringApplication.run(OMAGServerPlatform.class, (String[])args);
    }

    @Bean
    public InitializingBean getInitialize() {
        return () -> {
            if (!this.strictSSL.booleanValue()) {
                log.warn("strict.ssl is set to false! Invalid certificates will be accepted for connection!");
                HttpHelper.noStrictSSL();
            } else if (System.getProperty("javax.net.ssl.trustStore") == null) {
                System.setProperty("javax.net.ssl.trustStore", this.env.getProperty("server.ssl.trust-store"));
                System.setProperty("javax.net.ssl.trustStorePassword", this.env.getProperty("server.ssl.trust-store-password"));
            }
        };
    }

    List<String> getAutoStartList() {
        if (!this.startupServers.trim().isEmpty()) {
            String[] splits = this.startupServers.split(",");
            TreeSet serverSet = new TreeSet();
            Collections.addAll(serverSet, splits);
            if (!serverSet.isEmpty()) {
                return new ArrayList<String>(serverSet);
            }
        }
        return null;
    }

    private void autoStartConfig() {
        SuccessMessageResponse response;
        List servers = this.getAutoStartList();
        if (servers != null) {
            log.info("Startup detected for servers: {}", (Object)this.startupServers);
        }
        if ((response = this.operationalServices.activateServerListWithStoredConfig(this.sysUser.trim(), servers)).getRelatedHTTPCode() == 200) {
            this.startupMessage = response.getSuccessMessage();
        } else {
            this.startupMessage = "Server startup failed with error: " + response.getExceptionErrorMessage();
            StartupFailEvent customSpringEvent = new StartupFailEvent((Object)this, this.startupMessage);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)customSpringEvent);
            this.triggeredRuntimeHalt = true;
        }
    }

    private void temporaryDeactivateServers() {
        List servers = this.getAutoStartList();
        if (servers != null) {
            log.info("Temporarily deactivating any auto-started servers '{}'", (Object)servers);
            System.out.println(new Date() + " OMAG Server Platform shutdown requested. Shutting down auto-started servers (if running): " + servers);
            this.operationalServices.deactivateTemporarilyServerList(this.sysUser, servers);
        }
    }

    @Bean
    public FilterRegistrationBean<HttpRequestHeadersFilter> getRequestHeadersFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new HttpRequestHeadersFilter(this.headerNames));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(1);
        return registrationBean;
    }
}

