/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serverchassis.springboot;

import java.util.List;
import org.odpi.openmetadata.serverchassis.springboot.config.OMAGConfigHelper;
import org.odpi.openmetadata.serverchassis.springboot.exception.OMAGServerActivationError;
import org.odpi.openmetadata.serveroperations.rest.SuccessMessageResponse;
import org.odpi.openmetadata.serveroperations.server.OMAGServerOperationalServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

@SpringBootApplication(scanBasePackages={"org.odpi.openmetadata"})
public class OMAGServer
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(OMAGServer.class);
    private final ConfigurableApplicationContext context;
    private final OMAGServerOperationalServices operationalServices;
    private OMAGConfigHelper configHelper;

    @Autowired
    public OMAGServer(ConfigurableApplicationContext ctx, OMAGConfigHelper configHelper, OMAGServerOperationalServices omagServerOperationalServices) {
        this.context = ctx;
        this.operationalServices = omagServerOperationalServices;
        this.configHelper = configHelper;
    }

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[0]).sources(new Class[]{OMAGServer.class}).run(args);
    }

    public void run(ApplicationArguments args) {
        LOG.debug("Application runner executing run");
        try {
            this.activateOMAGServer();
        }
        catch (OMAGServerActivationError e) {
            LOG.error("Server activation failed due to internal application error", (Throwable)e);
            System.exit(SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[0]));
        }
    }

    @EventListener(value={ContextClosedEvent.class})
    private void onContextClosedEvent() {
        if (this.configHelper.getOmagServerConfig() != null) {
            LOG.info("Application stopped, deactivating server: {}", (Object)this.configHelper.getOmagServerConfig().getLocalServerName());
            this.operationalServices.deactivateTemporarilyServerList(this.configHelper.getOmagServerConfig().getLocalServerUserId(), List.of(this.configHelper.getOmagServerConfig().getLocalServerName()));
        }
    }

    private void activateOMAGServer() throws OMAGServerActivationError {
        LOG.debug("Activation started");
        this.configHelper.loadConfig();
        if (this.configHelper.getOmagServerConfig() == null) {
            LOG.info("Activation failed, the cause is that the OMAGServerConfig document is null");
            throw new OMAGServerActivationError("Activation failed, the cause is that the OMAGServerConfig document is null");
        }
        LOG.info("Sending activation request for server: {} and user: {}", (Object)this.configHelper.getOmagServerConfig().getLocalServerName(), (Object)this.configHelper.getOmagServerConfig().getLocalServerUserId());
        SuccessMessageResponse response = this.operationalServices.activateWithSuppliedConfig(this.configHelper.getOmagServerConfig().getLocalServerUserId(), this.configHelper.getOmagServerConfig().getLocalServerName(), this.configHelper.getOmagServerConfig());
        if (response == null) {
            LOG.info("Activation has failed. The cause is that response is null");
            throw new OMAGServerActivationError("Activation has failed. The cause is that response is null");
        }
        if (response.getRelatedHTTPCode() != 200) {
            LOG.info("Activation has failed with response code: {}", (Object)response.getRelatedHTTPCode());
            throw new OMAGServerActivationError(String.format("Server activation failed with response code %s", response.getRelatedHTTPCode()));
        }
        if (response.getRelatedHTTPCode() == 200) {
            LOG.info("Activation succeeded for server: {}", (Object)this.configHelper.getOmagServerConfig().getLocalServerName());
        }
    }
}

