/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serverchassis.springboot.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class ObjectMapperConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ObjectMapperConfiguration.class);

    private static ObjectMapper newObjectMapper(Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder) {
        return jackson2ObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL).failOnEmptyBeans(false).failOnUnknownProperties(false).featuresToEnable(new Object[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED}).build();
    }

    @Bean
    @Qualifier(value="jsonObjectMapper")
    ObjectMapper objectMapper(Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder) {
        return ObjectMapperConfiguration.newObjectMapper(jackson2ObjectMapperBuilder);
    }

    @Bean
    @Qualifier(value="yamlObjectMapper")
    public ObjectMapper yamlMapper() {
        return ((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)YAMLMapper.builder().disable(new YAMLGenerator.Feature[]{YAMLGenerator.Feature.WRITE_DOC_START_MARKER}).disable(new YAMLGenerator.Feature[]{YAMLGenerator.Feature.ALLOW_LONG_KEYS}).serializationInclusion(JsonInclude.Include.NON_NULL)).configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).build();
    }
}

