/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serverchassis.springboot.config;

import org.odpi.openmetadata.http.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SSLEnvironmentConfiguration {
    public static final String PREFIX = "SSL configuration started";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String OPTION_STRICT_SSL_IS_SET_TO_FALSE_INVALID_CERTIFICATES_WILL_BE_ACCEPTED_FOR_CONNECTION = "Option strict.ssl is set to false! Invalid certificates will be accepted for connection!";
    public static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String SERVER_SSL_TRUST_STORE = "server.ssl.trust-store";
    public static final String SERVER_SSL_TRUST_STORE_PASSWORD = "server.ssl.trust-store-password";
    public static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private final Environment env;
    @Value(value="${strict.ssl:true}")
    Boolean strictSSL;
    @Value(value="${server.ssl.enabled:true}")
    Boolean serverSSL;

    public SSLEnvironmentConfiguration(Environment env) {
        this.env = env;
    }

    @Bean
    public InitializingBean getInitialize() {
        return () -> {
            this.log.info("{} working directory: {}", (Object)PREFIX, (Object)System.getProperty("user.dir"));
            if (!this.strictSSL.booleanValue()) {
                this.log.warn("{} :: {}", (Object)PREFIX, (Object)OPTION_STRICT_SSL_IS_SET_TO_FALSE_INVALID_CERTIFICATES_WILL_BE_ACCEPTED_FOR_CONNECTION);
                HttpHelper.noStrictSSL();
            }
            if (this.serverSSL.booleanValue() && System.getProperty(JAVAX_NET_SSL_TRUST_STORE) == null) {
                this.log.warn("{} Java trust store '{}' is null - this is needed by Tomcat - using '{}'", new Object[]{PREFIX, JAVAX_NET_SSL_TRUST_STORE, SERVER_SSL_TRUST_STORE});
                if (this.env.getProperty(SERVER_SSL_TRUST_STORE) != null) {
                    System.setProperty(JAVAX_NET_SSL_TRUST_STORE, this.env.getProperty(SERVER_SSL_TRUST_STORE));
                }
                if (this.env.getProperty(SERVER_SSL_TRUST_STORE_PASSWORD) != null) {
                    System.setProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, this.env.getProperty(SERVER_SSL_TRUST_STORE_PASSWORD));
                }
            }
        };
    }
}

