/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serverchassis.springboot.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.google.common.io.Files;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.serverchassis.springboot.config.OMAGServerProperties;
import org.odpi.openmetadata.serverchassis.springboot.exception.OMAGServerActivationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.Yaml;

@EnableConfigurationProperties(value={OMAGServerProperties.class})
@Configuration
public class OMAGConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(OMAGConfigHelper.class);
    final OMAGServerProperties serverProperties;
    private final ObjectMapper jsonObjectMapper;
    private final ObjectMapper yamlObjectMapper;
    OMAGServerConfig omagServerConfig;
    static final String YAML = "yaml";
    static final String YML = "yml";
    static final String JSON = "json";

    @Autowired
    public OMAGConfigHelper(OMAGServerProperties properties, @Qualifier(value="jsonObjectMapper") ObjectMapper jsonObjectMapper, @Qualifier(value="yamlObjectMapper") ObjectMapper yamlObjectMapper) {
        this.serverProperties = properties;
        this.jsonObjectMapper = jsonObjectMapper;
        this.yamlObjectMapper = yamlObjectMapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadConfig() throws OMAGServerActivationError {
        try {
            if (this.isConfigurationFileProvided()) {
                Resource serverConfigFile = this.serverProperties.getServerConfigFile();
                log.info("Using configuration from {}", (Object)serverConfigFile);
                if (this.isJsonConfigurationFile(serverConfigFile)) {
                    log.debug("JSON file detected, reading values using jsonObjectMapper...");
                    this.omagServerConfig = (OMAGServerConfig)this.jsonObjectMapper.reader().readValue(serverConfigFile.getInputStream(), OMAGServerConfig.class);
                    return;
                } else {
                    if (!this.isYamlConfigurationFile(serverConfigFile)) throw new OMAGServerActivationError("Configuration file is not supported");
                    try {
                        log.debug("YAML file detected, reading values using yamlObjectMapper...");
                        this.omagServerConfig = (OMAGServerConfig)this.yamlObjectMapper.reader().readValue(serverConfigFile.getInputStream(), OMAGServerConfig.class);
                        return;
                    }
                    catch (InvalidTypeIdException e) {
                        log.debug("yamlObjectMapper failed reading values, trying snakeYaml...");
                        Yaml yaml = new Yaml();
                        this.omagServerConfig = (OMAGServerConfig)yaml.loadAs(serverConfigFile.getInputStream(), OMAGServerConfig.class);
                    }
                }
                return;
            } else {
                if (!this.isPropertiesConfiguration()) return;
                log.info("[EXPERIMENTAL] Configuring server using omag. application properties");
                this.omagServerConfig = this.serverProperties.getServerConfig();
            }
            return;
        }
        catch (Exception e) {
            log.info("Configuration document cannot be loaded from the resource provided - check application configuration");
            throw new OMAGServerActivationError("Configuration document cannot be loaded from the resource provided - check application configuration", (Throwable)e);
        }
    }

    private String getFileExtension(Resource serverConfigFile) {
        return Files.getFileExtension((String)Objects.requireNonNull(serverConfigFile.getFilename()));
    }

    private boolean isConfigurationFileProvided() {
        return this.serverProperties.getServerConfigFile() != null;
    }

    private boolean isJsonConfigurationFile(Resource serverConfigFile) {
        return JSON.equalsIgnoreCase(Objects.requireNonNull(this.getFileExtension(serverConfigFile)));
    }

    private boolean isYamlConfigurationFile(Resource serverConfigFile) {
        String fileExtension = Objects.requireNonNull(this.getFileExtension(serverConfigFile));
        return YAML.equalsIgnoreCase(fileExtension) || YML.equalsIgnoreCase(fileExtension);
    }

    private boolean isPropertiesConfiguration() {
        return this.serverProperties.getServerConfig() != null;
    }

    public OMAGServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public OMAGServerConfig getOmagServerConfig() {
        return this.omagServerConfig;
    }
}

