/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serveroperations.client;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.serveroperations.client.rest.ServerOperationsRESTClient;
import org.odpi.openmetadata.serveroperations.properties.ServerServicesStatus;
import org.odpi.openmetadata.serveroperations.properties.ServerStatus;
import org.odpi.openmetadata.serveroperations.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerServicesListResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerStatusResponse;

public class ServerOperationsClient {
    private final ServerOperationsRESTClient restClient;
    private final String platformRootURL;
    protected AuditLog auditLog;
    private final String retrieveURLTemplatePrefix = "/open-metadata/server-operations/users/{0}";
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public ServerOperationsClient(String platformName, String platformRootURL, AuditLog auditLog) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new ServerOperationsRESTClient(platformName, platformRootURL, auditLog);
    }

    public ServerOperationsClient(String platformName, String platformRootURL) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new ServerOperationsRESTClient(platformName, platformRootURL);
    }

    public ServerOperationsClient(String platformName, String platformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new ServerOperationsRESTClient(platformName, platformRootURL, userId, password, auditLog);
    }

    public ServerOperationsClient(String platformName, String platformRootURL, String userId, String password) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new ServerOperationsRESTClient(platformName, platformRootURL, userId, password);
    }

    public ServerStatus getServerStatus(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getServerStatus";
        this.invalidParameterHandler.validateUserId(userId, "getServerStatus");
        String urlTemplate = this.platformRootURL + "/open-metadata/server-operations/users/{0}/servers/" + serverName + "/status";
        ServerStatusResponse restResult = this.restClient.callServerStatusGetRESTCall("getServerStatus", urlTemplate, userId);
        ServerStatus serverStatus = new ServerStatus();
        serverStatus.setServerName(restResult.getServerName());
        serverStatus.setIsActive(restResult.isActive());
        serverStatus.setServerStartTime(restResult.getServerStartTime());
        serverStatus.setServerEndTime(restResult.getServerEndTime());
        serverStatus.setServerHistory(restResult.getServerHistory());
        return serverStatus;
    }

    public OMAGServerConfig getActiveConfiguration(String userId, String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getActiveConfiguration";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/server-operations/users/{0}/servers/{1}/instance/configuration";
        this.invalidParameterHandler.validateUserId(userId, "getActiveConfiguration");
        this.invalidParameterHandler.validateName(serverName, "serverName", "getActiveConfiguration");
        OMAGServerConfigResponse restResult = this.restClient.callOMAGServerConfigGetRESTCall("getActiveConfiguration", urlTemplate, userId, serverName);
        return restResult.getOMAGServerConfig();
    }

    public ServerServicesStatus getActiveServerStatus(String userId, String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getActiveServerStatus";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/server-operations/users/{0}/servers/{1}/instance/status";
        this.invalidParameterHandler.validateUserId(userId, "getActiveServerStatus");
        this.invalidParameterHandler.validateName(serverName, "serverName", "getActiveServerStatus");
        OMAGServerStatusResponse restResult = this.restClient.callOMAGServerStatusGetRESTCall("getActiveServerStatus", urlTemplate, userId, serverName);
        return restResult.getServerStatus();
    }

    public List<String> getActiveServices(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveServices";
        String serverNameParameter = "serverName";
        this.invalidParameterHandler.validateUserId(userId, "getActiveServices");
        this.invalidParameterHandler.validateName(serverName, "serverName", "getActiveServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/server-operations/users/{0}/servers/" + serverName + "/services";
        ServerServicesListResponse restResult = this.restClient.callServiceListGetRESTCall("getActiveServices", urlTemplate, userId);
        return restResult.getServerServicesList();
    }

    public void addOpenMetadataArchiveFile(String userId, String serverName, String fileName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "addOpenMetadataArchiveFile";
        String parameterName = "fileName";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/server-operations/users/{0}/servers/{1}/instance/open-metadata-archives/file";
        this.invalidParameterHandler.validateUserId(userId, "addOpenMetadataArchiveFile");
        this.invalidParameterHandler.validateName(serverName, "serverName", "addOpenMetadataArchiveFile");
        this.invalidParameterHandler.validateName(fileName, "fileName", "addOpenMetadataArchiveFile");
        this.restClient.callVoidPostRESTCall("addOpenMetadataArchiveFile", urlTemplate, fileName, new Object[]{userId, serverName});
    }

    public void addOpenMetadataArchive(String userId, String serverName, Connection connection) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "addOpenMetadataArchiveFile";
        String parameterName = "connection";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/server-operations/users/{0}/servers/{1}/instance/open-metadata-archives/connection";
        this.invalidParameterHandler.validateUserId(userId, "addOpenMetadataArchiveFile");
        this.invalidParameterHandler.validateName(serverName, "serverName", "addOpenMetadataArchiveFile");
        this.invalidParameterHandler.validateConnection(connection, "connection", "addOpenMetadataArchiveFile");
        this.restClient.callVoidPostRESTCall("addOpenMetadataArchiveFile", urlTemplate, connection, new Object[]{userId, serverName});
    }

    public void addOpenMetadataArchiveContent(String userId, String serverName, OpenMetadataArchive openMetadataArchive) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "addOpenMetadataArchiveContent";
        String parameterName = "openMetadataArchive";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/server-operations/users/{0}/servers/{1}/instance/open-metadata-archives/archive-content";
        this.invalidParameterHandler.validateUserId(userId, "addOpenMetadataArchiveContent");
        this.invalidParameterHandler.validateName(serverName, "serverName", "addOpenMetadataArchiveContent");
        this.invalidParameterHandler.validateObject((Object)openMetadataArchive, "openMetadataArchive", "addOpenMetadataArchiveContent");
        this.restClient.callVoidPostRESTCall("addOpenMetadataArchiveContent", urlTemplate, openMetadataArchive, new Object[]{userId, serverName});
    }
}

