/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serveroperations.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.classifier.ServerTypeClassifier;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.registration.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.registration.OMAGViewServiceRegistration;
import org.odpi.openmetadata.adminservices.registration.ViewServiceAdmin;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.conformance.server.ConformanceSuiteOperationalServices;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworkservices.gaf.admin.GAFMetadataOperationalServices;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.admin.OCFMetadataOperationalServices;
import org.odpi.openmetadata.frameworkservices.oif.admin.OIFMetadataOperationalServices;
import org.odpi.openmetadata.governanceservers.enginehostservices.registration.OMAGEngineServiceRegistration;
import org.odpi.openmetadata.governanceservers.enginehostservices.server.EngineHostOperationalServices;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonOperationalServices;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.admin.OMRSOperationalServices;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.serveroperations.ffdc.ServerOpsAuditCode;
import org.odpi.openmetadata.serveroperations.ffdc.ServerOpsErrorCode;
import org.odpi.openmetadata.serveroperations.properties.ServerActiveStatus;
import org.odpi.openmetadata.serveroperations.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerServicesListResponse;
import org.odpi.openmetadata.serveroperations.rest.SuccessMessageResponse;
import org.odpi.openmetadata.serveroperations.server.OMAGOperationalServicesInstance;
import org.odpi.openmetadata.serveroperations.server.OMAGServerOperationalInstanceHandler;
import org.odpi.openmetadata.serveroperations.server.OpenMetadataArchiveWrapper;
import org.slf4j.LoggerFactory;

public class OMAGServerOperationalServices {
    private final OMAGServerOperationalInstanceHandler instanceHandler = new OMAGServerOperationalInstanceHandler(CommonServicesDescription.SERVER_OPERATIONS.getServiceName());
    private final OMAGServerPlatformInstanceMap platformInstanceMap = new OMAGServerPlatformInstanceMap();
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerOperationalServices.class), CommonServicesDescription.SERVER_OPERATIONS.getServiceName());

    public SuccessMessageResponse activateServerListWithStoredConfig(String userId, List<String> serverNames) {
        Object startUpMessage = null;
        SuccessMessageResponse response = new SuccessMessageResponse();
        response.setRelatedHTTPCode(200);
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                response = this.activateWithStoredConfig(userId, serverName.trim());
                if (response.getRelatedHTTPCode() == 200) {
                    String serverStartUpMessage = "OMAG Server '" + serverName + "' successful start , with message: " + response.getSuccessMessage() + System.lineSeparator();
                    if (startUpMessage == null) {
                        startUpMessage = serverStartUpMessage;
                        continue;
                    }
                    startUpMessage = (String)startUpMessage + serverStartUpMessage;
                    continue;
                }
                break;
            }
        } else {
            startUpMessage = "No OMAG servers listed in startup configuration";
        }
        if (response.getRelatedHTTPCode() == 200) {
            response.setSuccessMessage(new Date() + " " + (String)startUpMessage);
        }
        return response;
    }

    public SuccessMessageResponse activateWithStoredConfig(String userId, String serverName) {
        String methodName = "activateWithStoredConfig";
        SuccessMessageResponse response = new SuccessMessageResponse();
        try {
            this.errorHandler.validateServerName(serverName, "activateWithStoredConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithStoredConfig");
            response = this.activateWithSuppliedConfig(userId, serverName, this.configStore.getServerConfigForStartUp(userId, serverName, "activateWithStoredConfig"));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "activateWithStoredConfig", (FFDCResponseBase)response, (Throwable)error);
        }
        return response;
    }

    private void refreshRegisteredServices(OMAGServerConfig serverConfig, AuditLog auditLog) {
        EngineHostServicesConfig engineHostServicesConfig;
        AccessServiceRegistrationEntry description;
        String methodName = "refreshRegisteredServices";
        if (serverConfig.getAccessServicesConfig() != null) {
            ArrayList<Object> accessServiceConfigList = new ArrayList<Object>();
            for (Object accessServiceConfig : serverConfig.getAccessServicesConfig()) {
                if (accessServiceConfig == null) continue;
                description = OMAGAccessServiceRegistration.getAccessServiceRegistration((String)accessServiceConfig.getAccessServiceURLMarker());
                if (description != null) {
                    accessServiceConfig.setAccessServiceName(description.getAccessServiceName());
                    accessServiceConfig.setAccessServiceDevelopmentStatus(description.getAccessServiceDevelopmentStatus());
                    accessServiceConfig.setAccessServiceFullName(description.getAccessServiceFullName());
                    accessServiceConfig.setAccessServiceDescription(description.getAccessServiceDescription());
                    accessServiceConfig.setAccessServiceURLMarker(description.getAccessServiceURLMarker());
                    accessServiceConfig.setAccessServiceWiki(description.getAccessServiceWiki());
                    accessServiceConfig.setAccessServiceOperationalStatus(description.getAccessServiceOperationalStatus());
                    accessServiceConfigList.add(accessServiceConfig);
                    continue;
                }
                auditLog.logMessage("refreshRegisteredServices", OMAGAdminAuditCode.IGNORING_UNREGISTERED_SERVICE.getMessageDefinition(new String[]{accessServiceConfig.getAccessServiceFullName(), serverConfig.getLocalServerName()}));
            }
            serverConfig.setAccessServicesConfig(accessServiceConfigList);
        }
        if (serverConfig.getEngineHostServicesConfig() != null && (engineHostServicesConfig = serverConfig.getEngineHostServicesConfig()).getEngineServiceConfigs() != null) {
            ArrayList<EngineServiceConfig> engineServiceConfigList = new ArrayList<EngineServiceConfig>();
            for (EngineServiceConfig engineServiceConfig : engineHostServicesConfig.getEngineServiceConfigs()) {
                if (engineServiceConfig == null) continue;
                EngineServiceRegistrationEntry description2 = OMAGEngineServiceRegistration.getEngineServiceRegistration((String)engineServiceConfig.getEngineServiceURLMarker());
                if (description2 != null) {
                    engineServiceConfig.setEngineServiceName(description2.getEngineServiceName());
                    engineServiceConfig.setEngineServiceDevelopmentStatus(description2.getEngineServiceDevelopmentStatus());
                    engineServiceConfig.setEngineServiceFullName(description2.getEngineServiceFullName());
                    engineServiceConfig.setEngineServiceDescription(description2.getEngineServiceDescription());
                    engineServiceConfig.setEngineServiceURLMarker(description2.getEngineServiceURLMarker());
                    engineServiceConfig.setEngineServiceWiki(description2.getEngineServiceWiki());
                    engineServiceConfig.setEngineServicePartnerOMAS(description2.getEngineServicePartnerOMAS());
                    engineServiceConfig.setEngineServiceOperationalStatus(description2.getEngineServiceOperationalStatus());
                    engineServiceConfigList.add(engineServiceConfig);
                    continue;
                }
                auditLog.logMessage("refreshRegisteredServices", OMAGAdminAuditCode.IGNORING_UNREGISTERED_SERVICE.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceName(), serverConfig.getLocalServerName()}));
            }
            engineHostServicesConfig.setEngineServiceConfigs(engineServiceConfigList);
        }
        if (serverConfig.getIntegrationServicesConfig() != null) {
            ArrayList<IntegrationServiceConfig> integrationServiceConfigList = new ArrayList<IntegrationServiceConfig>();
            for (IntegrationServiceConfig integrationServiceConfig : serverConfig.getIntegrationServicesConfig()) {
                if (integrationServiceConfig == null) continue;
                try {
                    description = IntegrationServiceRegistry.getIntegrationServiceConfig((String)integrationServiceConfig.getIntegrationServiceURLMarker(), (String)serverConfig.getLocalServerName(), (String)"refreshRegisteredServices");
                    integrationServiceConfig.setIntegrationServiceName(description.getIntegrationServiceName());
                    integrationServiceConfig.setIntegrationServiceDevelopmentStatus(description.getIntegrationServiceDevelopmentStatus());
                    integrationServiceConfig.setIntegrationServiceFullName(description.getIntegrationServiceFullName());
                    integrationServiceConfig.setIntegrationServiceDescription(description.getIntegrationServiceDescription());
                    integrationServiceConfig.setIntegrationServiceURLMarker(description.getIntegrationServiceURLMarker());
                    integrationServiceConfig.setIntegrationServiceWiki(description.getIntegrationServiceWiki());
                    integrationServiceConfig.setIntegrationServicePartnerOMAS(description.getIntegrationServicePartnerOMAS());
                    integrationServiceConfig.setIntegrationServiceOperationalStatus(description.getIntegrationServiceOperationalStatus());
                    integrationServiceConfigList.add(integrationServiceConfig);
                }
                catch (InvalidParameterException exception) {
                    auditLog.logMessage("refreshRegisteredServices", OMAGAdminAuditCode.IGNORING_UNREGISTERED_SERVICE.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceName(), serverConfig.getLocalServerName()}));
                }
            }
            serverConfig.setIntegrationServicesConfig(integrationServiceConfigList);
        }
        if (serverConfig.getViewServicesConfig() != null) {
            ArrayList<ViewServiceConfig> viewServiceConfigList = new ArrayList<ViewServiceConfig>();
            for (ViewServiceConfig viewServiceConfig : serverConfig.getViewServicesConfig()) {
                if (viewServiceConfig == null) continue;
                description = OMAGViewServiceRegistration.getViewServiceRegistration((String)viewServiceConfig.getViewServiceURLMarker());
                if (description != null) {
                    viewServiceConfig.setViewServiceName(description.getViewServiceName());
                    viewServiceConfig.setViewServiceDevelopmentStatus(description.getViewServiceDevelopmentStatus());
                    viewServiceConfig.setViewServiceFullName(description.getViewServiceFullName());
                    viewServiceConfig.setViewServiceDescription(description.getViewServiceDescription());
                    viewServiceConfig.setViewServiceURLMarker(description.getViewServiceURLMarker());
                    viewServiceConfig.setViewServiceWiki(description.getViewServiceWiki());
                    viewServiceConfig.setViewServicePartnerService(description.getViewServicePartnerService());
                    viewServiceConfig.setViewServiceOperationalStatus(ServiceOperationalStatus.ENABLED);
                    viewServiceConfigList.add(viewServiceConfig);
                    continue;
                }
                auditLog.logMessage("refreshRegisteredServices", OMAGAdminAuditCode.IGNORING_UNREGISTERED_SERVICE.getMessageDefinition(new String[]{viewServiceConfig.getViewServiceName(), serverConfig.getLocalServerName()}));
            }
            serverConfig.setViewServicesConfig(viewServiceConfigList);
        }
    }

    public SuccessMessageResponse activateWithSuppliedConfig(String userId, String serverName, OMAGServerConfig configuration) {
        String methodName = "activateWithSuppliedConfig";
        String actionDescription = "Initialize OMAG Server subsystems";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "activateWithSuppliedConfig");
        ArrayList<String> activatedServiceList = new ArrayList<String>();
        OMAGOperationalServicesInstance instance = null;
        SuccessMessageResponse response = new SuccessMessageResponse();
        try {
            this.errorHandler.validateServerName(serverName, "activateWithSuppliedConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithSuppliedConfig");
            ServerTypeClassifier serverTypeClassifier = new ServerTypeClassifier(serverName, configuration);
            ServerTypeClassification serverTypeClassification = serverTypeClassifier.getServerType();
            if (configuration.getLocalServerType() == null) {
                configuration.setLocalServerType(serverTypeClassification.getServerTypeName());
            }
            if (this.instanceHandler.isServerActive(userId, serverName)) {
                this.shutdownServer(userId, serverName);
            }
            instance = new OMAGOperationalServicesInstance(serverName, serverTypeClassification, CommonServicesDescription.SERVER_OPERATIONS.getServiceName(), configuration.getMaxPageSize());
            instance.setServerActiveStatus(ServerActiveStatus.STARTING);
            instance.setOperationalConfiguration(configuration);
            instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.STARTING);
            OMRSOperationalServices operationalRepositoryServices = new OMRSOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getLocalServerURL(), configuration.getMaxPageSize());
            activatedServiceList.add(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName());
            operationalRepositoryServices.initializeAuditLog(configuration.getRepositoryServicesConfig(), serverTypeClassification.getServerTypeName());
            OMRSAuditLog auditLog = operationalRepositoryServices.getAuditLog(CommonServicesDescription.SERVER_OPERATIONS.getServiceCode(), CommonServicesDescription.SERVER_OPERATIONS.getServiceDevelopmentStatus(), CommonServicesDescription.SERVER_OPERATIONS.getServiceName(), CommonServicesDescription.SERVER_OPERATIONS.getServiceDescription(), CommonServicesDescription.SERVER_OPERATIONS.getServiceWiki());
            instance.setAuditLog(auditLog);
            this.refreshRegisteredServices(configuration, (AuditLog)auditLog);
            this.validateMaxPageSize(configuration.getMaxPageSize(), serverName, auditLog);
            instance.setOperationalRepositoryServices(operationalRepositoryServices);
            if (ServerTypeClassification.METADATA_ACCESS_STORE.equals((Object)serverTypeClassification) || ServerTypeClassification.METADATA_ACCESS_SERVER.equals((Object)serverTypeClassification) || ServerTypeClassification.REPOSITORY_PROXY.equals((Object)serverTypeClassification) || ServerTypeClassification.CONFORMANCE_SERVER.equals((Object)serverTypeClassification)) {
                operationalRepositoryServices.initializeCohortMember(configuration.getRepositoryServicesConfig());
                OpenMetadataServerSecurityVerifier securityVerifier = this.platformInstanceMap.startUpServerInstance(configuration.getLocalServerUserId(), serverName, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceCode(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDevelopmentStatus(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceName(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDescription(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceWiki()), configuration.getServerSecurityConnection());
                operationalRepositoryServices.setSecurityVerifier(securityVerifier);
                instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
                OMRSRepositoryConnector enterpriseRepositoryConnector = operationalRepositoryServices.getEnterpriseOMRSRepositoryConnector(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName());
                if (enterpriseRepositoryConnector != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STARTING);
                    OCFMetadataOperationalServices operationalOCFMetadataServices = new OCFMetadataOperationalServices(configuration.getLocalServerName(), enterpriseRepositoryConnector, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceCode(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceDevelopmentStatus(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceDescription(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceWiki()), configuration.getLocalServerUserId(), configuration.getMaxPageSize());
                    instance.setOperationalOCFMetadataServices(operationalOCFMetadataServices);
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.RUNNING);
                    activatedServiceList.add(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName());
                    instance.setServerServiceActiveStatus(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STARTING);
                    GAFMetadataOperationalServices operationalGAFMetadataServices = new GAFMetadataOperationalServices(configuration.getLocalServerName(), enterpriseRepositoryConnector, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceCode(), CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceDevelopmentStatus(), CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceDescription(), CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceWiki()), configuration.getLocalServerUserId(), configuration.getMaxPageSize());
                    instance.setOperationalGAFMetadataServices(operationalGAFMetadataServices);
                    activatedServiceList.add(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName());
                    instance.setServerServiceActiveStatus(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.RUNNING);
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STARTING);
                    OIFMetadataOperationalServices operationalOIFMetadataServices = new OIFMetadataOperationalServices(configuration.getLocalServerName(), enterpriseRepositoryConnector, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceCode(), CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceDevelopmentStatus(), CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceName(), CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceDescription(), CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceWiki()), configuration.getLocalServerUserId(), configuration.getMaxPageSize());
                    instance.setOperationalOIFMetadataServices(operationalOIFMetadataServices);
                    activatedServiceList.add(CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceName());
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.RUNNING);
                }
                OMRSTopicConnector enterpriseTopicConnector = operationalRepositoryServices.getEnterpriseOMRSTopicConnector();
                this.initializeAccessServices(instance, configuration.getAccessServicesConfig(), operationalRepositoryServices, enterpriseTopicConnector, configuration.getLocalServerUserId(), serverName, activatedServiceList, auditLog);
                if (ServerTypeClassification.CONFORMANCE_SERVER.equals((Object)serverTypeClassification)) {
                    ConformanceSuiteOperationalServices operationalConformanceSuiteServices = new ConformanceSuiteOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
                    instance.setOperationalConformanceSuiteServices(operationalConformanceSuiteServices);
                    operationalConformanceSuiteServices.initialize(configuration.getConformanceSuiteConfig(), enterpriseTopicConnector, operationalRepositoryServices.getEnterpriseConnectorManager(), operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceCode(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceDevelopmentStatus(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceDescription(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceWiki()));
                    activatedServiceList.add(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName());
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
                }
                if (enterpriseTopicConnector != null) {
                    try {
                        enterpriseTopicConnector.start();
                    }
                    catch (Exception error) {
                        throw new OMAGConfigurationErrorException(ServerOpsErrorCode.ENTERPRISE_TOPIC_START_FAILED.getMessageDefinition(new String[]{serverName, "in memory", error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "activateWithSuppliedConfig");
                    }
                }
                operationalRepositoryServices.startOutboundEvents();
            } else if (ServerTypeClassification.VIEW_SERVER.equals((Object)serverTypeClassification)) {
                operationalRepositoryServices.initializeViewServer(configuration.getRepositoryServicesConfig());
                instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
                this.platformInstanceMap.startUpServerInstance(configuration.getLocalServerUserId(), serverName, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceCode(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDevelopmentStatus(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceName(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDescription(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceWiki()), configuration.getServerSecurityConnection());
                this.initializeViewServices(instance, configuration.getViewServicesConfig(), operationalRepositoryServices, configuration.getLocalServerUserId(), serverName, activatedServiceList, configuration.getMaxPageSize(), auditLog);
            } else {
                operationalRepositoryServices.initializeGovernanceServer(configuration.getRepositoryServicesConfig());
                instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
                this.platformInstanceMap.startUpServerInstance(configuration.getLocalServerUserId(), serverName, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceCode(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDevelopmentStatus(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceName(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDescription(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceWiki()), configuration.getServerSecurityConnection());
                try {
                    auditLog.logMessage("Initialize OMAG Server subsystems", ServerOpsAuditCode.STARTING_GOVERNANCE_SERVICES.getMessageDefinition(new String[]{serverTypeClassifier.getServerType().getServerTypeName(), serverName}));
                    this.initializeGovernanceServices(instance, configuration, serverTypeClassification, operationalRepositoryServices, activatedServiceList);
                    auditLog.logMessage("Initialize OMAG Server subsystems", ServerOpsAuditCode.GOVERNANCE_SERVICES_STARTED.getMessageDefinition(new String[]{serverTypeClassifier.getServerType().getServerTypeName(), serverName}));
                }
                catch (OMAGConfigurationErrorException error) {
                    auditLog.logException("Initialize OMAG Server subsystems", ServerOpsAuditCode.GOVERNANCE_SERVICE_FAILURE.getMessageDefinition(new String[]{((Object)((Object)error)).getClass().getName(), serverTypeClassifier.getServerType().getServerTypeName(), serverName, error.getReportedErrorMessage()}), (Throwable)error);
                    throw error;
                }
                catch (Exception error) {
                    auditLog.logException("Initialize OMAG Server subsystems", ServerOpsAuditCode.GOVERNANCE_SERVICE_FAILURE.getMessageDefinition(new String[]{error.getClass().getName(), serverTypeClassifier.getServerType().getServerTypeName(), serverName, error.getMessage()}), (Throwable)error);
                    throw error;
                }
            }
            instance.setServerActiveStatus(ServerActiveStatus.RUNNING);
            String successMessage = new Date() + " " + serverName + " is running the following services: " + activatedServiceList;
            auditLog.logMessage("Initialize OMAG Server subsystems", ServerOpsAuditCode.SERVER_STARTUP_SUCCESS.getMessageDefinition(new String[]{serverName, ((Object)activatedServiceList).toString()}));
            response.setSuccessMessage(successMessage);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, instance);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, instance);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, instance);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, instance);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "activateWithSuppliedConfig", (FFDCResponseBase)response, (Throwable)error);
            this.cleanUpRunningServiceInstances(userId, serverName, instance);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private void validateMaxPageSize(int maxPageSize, String serverName, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "Validating max page size during server initialization";
        if (maxPageSize > 0) {
            auditLog.logMessage("Validating max page size during server initialization", ServerOpsAuditCode.MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName, Integer.toString(maxPageSize)}));
        } else if (maxPageSize == 0) {
            auditLog.logMessage("Validating max page size during server initialization", ServerOpsAuditCode.UNLIMITED_MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName}));
        } else {
            auditLog.logMessage("Validating max page size during server initialization", ServerOpsAuditCode.INVALID_MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName, Integer.toString(maxPageSize)}));
            throw new OMAGConfigurationErrorException(ServerOpsErrorCode.BAD_MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName, Integer.toString(maxPageSize)}), this.getClass().getName(), "Validating max page size during server initialization");
        }
    }

    private void initializeAccessServices(OMAGOperationalServicesInstance instance, List<AccessServiceConfig> accessServiceConfigList, OMRSOperationalServices operationalRepositoryServices, OMRSTopicConnector enterpriseTopicConnector, String localServerUserId, String serverName, List<String> activatedServiceList, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "initializeAccessServices";
        String actionDescription = "Initialize Access Services";
        List<AccessServiceAdmin> operationalAccessServiceAdminList = instance.getOperationalAccessServiceAdminList();
        if (accessServiceConfigList != null) {
            auditLog.logMessage("Initialize Access Services", ServerOpsAuditCode.STARTING_ACCESS_SERVICES.getMessageDefinition());
            int configuredAccessServiceCount = 0;
            int enabledAccessServiceCount = 0;
            for (AccessServiceConfig accessServiceConfig : accessServiceConfigList) {
                if (accessServiceConfig == null) continue;
                ++configuredAccessServiceCount;
                if (ServiceOperationalStatus.ENABLED.equals((Object)accessServiceConfig.getAccessServiceOperationalStatus())) {
                    ++enabledAccessServiceCount;
                    instance.setServerServiceActiveStatus(accessServiceConfig.getAccessServiceFullName(), ServerActiveStatus.STARTING);
                    try {
                        AccessServiceAdmin accessServiceAdmin = this.getAccessServiceAdminClass(accessServiceConfig, auditLog, serverName);
                        accessServiceAdmin.setFullServiceName(accessServiceConfig.getAccessServiceFullName());
                        OMRSAuditLog accessServicesAuditLog = operationalRepositoryServices.getAuditLog(accessServiceConfig.getAccessServiceId(), accessServiceConfig.getAccessServiceDevelopmentStatus(), accessServiceConfig.getAccessServiceFullName(), accessServiceConfig.getAccessServiceDescription(), accessServiceConfig.getAccessServiceWiki());
                        accessServiceAdmin.initialize(accessServiceConfig, enterpriseTopicConnector, operationalRepositoryServices.getEnterpriseOMRSRepositoryConnector(accessServiceConfig.getAccessServiceFullName()), accessServicesAuditLog, localServerUserId);
                        operationalAccessServiceAdminList.add(accessServiceAdmin);
                        activatedServiceList.add(accessServiceConfig.getAccessServiceFullName());
                        instance.setServerServiceActiveStatus(accessServiceAdmin.getFullServiceName(), ServerActiveStatus.RUNNING);
                        continue;
                    }
                    catch (OMAGConfigurationErrorException error) {
                        auditLog.logException("initializeAccessServices", ServerOpsAuditCode.ACCESS_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{accessServiceConfig.getAccessServiceName(), error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
                        throw error;
                    }
                    catch (Exception error) {
                        auditLog.logException("initializeAccessServices", ServerOpsAuditCode.ACCESS_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage(), accessServiceConfig.getAccessServiceName(), error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
                        throw new OMAGConfigurationErrorException(ServerOpsErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{serverName, accessServiceConfig.getAccessServiceName(), error.getMessage()}), this.getClass().getName(), "initializeAccessServices", (Throwable)error);
                    }
                }
                auditLog.logMessage("Initialize Access Services", ServerOpsAuditCode.SKIPPING_ACCESS_SERVICE.getMessageDefinition(new String[]{accessServiceConfig.getAccessServiceFullName(), serverName}));
            }
            auditLog.logMessage("Initialize Access Services", ServerOpsAuditCode.ALL_ACCESS_SERVICES_STARTED.getMessageDefinition(new String[]{Integer.toString(enabledAccessServiceCount), Integer.toString(configuredAccessServiceCount)}));
        }
        instance.setOperationalAccessServiceAdminList(operationalAccessServiceAdminList);
    }

    private void initializeViewServices(OMAGOperationalServicesInstance instance, List<ViewServiceConfig> viewServiceConfigList, OMRSOperationalServices operationalRepositoryServices, String localServerUserId, String serverName, List<String> activatedServiceList, int maxPageSize, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "initializeViewServices";
        String actionDescription = "Initialize View Services";
        List<ViewServiceAdmin> operationalViewServiceAdminList = instance.getOperationalViewServiceAdminList();
        if (viewServiceConfigList != null) {
            auditLog.logMessage("Initialize View Services", ServerOpsAuditCode.STARTING_VIEW_SERVICES.getMessageDefinition());
            int configuredViewServiceCount = 0;
            int enabledViewServiceCount = 0;
            for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                ++configuredViewServiceCount;
                if (ServiceOperationalStatus.ENABLED.equals((Object)viewServiceConfig.getViewServiceOperationalStatus())) {
                    ++enabledViewServiceCount;
                    instance.setServerServiceActiveStatus(viewServiceConfig.getViewServiceFullName(), ServerActiveStatus.STARTING);
                    try {
                        ViewServiceAdmin viewServiceAdmin = this.getViewServiceAdminClass(viewServiceConfig, auditLog, serverName);
                        OMRSAuditLog viewServicesAuditLog = operationalRepositoryServices.getAuditLog(viewServiceConfig.getViewServiceId(), viewServiceConfig.getViewServiceDevelopmentStatus(), viewServiceConfig.getViewServiceFullName(), viewServiceConfig.getViewServiceDescription(), viewServiceConfig.getViewServiceWiki());
                        viewServiceAdmin.initialize(serverName, viewServiceConfig, (AuditLog)viewServicesAuditLog, localServerUserId, maxPageSize);
                        operationalViewServiceAdminList.add(viewServiceAdmin);
                        activatedServiceList.add(viewServiceConfig.getViewServiceFullName());
                        instance.setServerServiceActiveStatus(viewServiceConfig.getViewServiceFullName(), ServerActiveStatus.RUNNING);
                        continue;
                    }
                    catch (OMAGConfigurationErrorException error) {
                        auditLog.logException("initializeViewServices", ServerOpsAuditCode.VIEW_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{viewServiceConfig.getViewServiceName(), error.getMessage()}), viewServiceConfig.toString(), (Throwable)error);
                        throw error;
                    }
                    catch (Exception error) {
                        auditLog.logException("initializeViewServices", ServerOpsAuditCode.VIEW_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage(), viewServiceConfig.getViewServiceName(), error.getMessage()}), viewServiceConfig.toString(), (Throwable)error);
                        throw new OMAGConfigurationErrorException(ServerOpsErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{serverName, viewServiceConfig.getViewServiceName(), error.getMessage()}), this.getClass().getName(), "initializeViewServices", (Throwable)error);
                    }
                }
                auditLog.logMessage("Initialize View Services", ServerOpsAuditCode.SKIPPING_VIEW_SERVICE.getMessageDefinition(new String[]{viewServiceConfig.getViewServiceFullName(), serverName}));
            }
            auditLog.logMessage("Initialize View Services", ServerOpsAuditCode.ALL_VIEW_SERVICES_STARTED.getMessageDefinition(new String[]{Integer.toString(enabledViewServiceCount), Integer.toString(configuredViewServiceCount)}));
        }
        instance.setOperationalViewServiceAdminList(operationalViewServiceAdminList);
    }

    private AccessServiceAdmin getAccessServiceAdminClass(AccessServiceConfig accessServiceConfig, OMRSAuditLog auditLog, String serverName) throws OMAGConfigurationErrorException {
        String methodName = "getAccessServiceAdminClass";
        String accessServiceAdminClassName = accessServiceConfig.getAccessServiceAdminClass();
        if (accessServiceAdminClassName != null) {
            try {
                return (AccessServiceAdmin)Class.forName(accessServiceAdminClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception error) {
                auditLog.logException("getAccessServiceAdminClass", ServerOpsAuditCode.BAD_ACCESS_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{accessServiceConfig.getAccessServiceName(), accessServiceAdminClassName, error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
                throw new OMAGConfigurationErrorException(ServerOpsErrorCode.BAD_ACCESS_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, accessServiceAdminClassName, accessServiceConfig.getAccessServiceName()}), this.getClass().getName(), "getAccessServiceAdminClass", (Throwable)error);
            }
        }
        auditLog.logMessage("getAccessServiceAdminClass", ServerOpsAuditCode.NULL_ACCESS_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, accessServiceConfig.getAccessServiceFullName()}), accessServiceConfig.toString());
        throw new OMAGConfigurationErrorException(ServerOpsErrorCode.NULL_ACCESS_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, accessServiceConfig.getAccessServiceName()}), this.getClass().getName(), "getAccessServiceAdminClass");
    }

    private ViewServiceAdmin getViewServiceAdminClass(ViewServiceConfig viewServiceConfig, OMRSAuditLog auditLog, String serverName) throws OMAGConfigurationErrorException {
        String methodName = "getViewServiceAdminClass";
        String viewServiceAdminClassName = viewServiceConfig.getViewServiceAdminClass();
        if (viewServiceAdminClassName != null) {
            try {
                return (ViewServiceAdmin)Class.forName(viewServiceAdminClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception error) {
                auditLog.logException("getViewServiceAdminClass", ServerOpsAuditCode.BAD_VIEW_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{viewServiceConfig.getViewServiceName(), viewServiceAdminClassName, error.getMessage()}), viewServiceConfig.toString(), (Throwable)error);
                throw new OMAGConfigurationErrorException(ServerOpsErrorCode.BAD_VIEW_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, viewServiceAdminClassName, viewServiceConfig.getViewServiceName()}), this.getClass().getName(), "getViewServiceAdminClass", (Throwable)error);
            }
        }
        auditLog.logMessage("getViewServiceAdminClass", ServerOpsAuditCode.NULL_VIEW_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, viewServiceConfig.getViewServiceFullName()}), viewServiceConfig.toString());
        throw new OMAGConfigurationErrorException(ServerOpsErrorCode.NULL_VIEW_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, viewServiceConfig.getViewServiceName()}), this.getClass().getName(), "getViewServiceAdminClass");
    }

    private void initializeGovernanceServices(OMAGOperationalServicesInstance instance, OMAGServerConfig configuration, ServerTypeClassification serverTypeClassification, OMRSOperationalServices operationalRepositoryServices, List<String> activatedServiceList) throws OMAGConfigurationErrorException {
        if (ServerTypeClassification.ENGINE_HOST.equals((Object)serverTypeClassification)) {
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), ServerActiveStatus.STARTING);
            EngineHostOperationalServices engineHostOperationalServices = new EngineHostOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerId(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
            instance.setOperationalEngineHost(engineHostOperationalServices);
            List engineServices = engineHostOperationalServices.initialize(configuration.getEngineHostServicesConfig(), (AuditLog)operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceCode(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceDevelopmentStatus(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceDescription(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceWiki()));
            activatedServiceList.addAll(engineServices);
            activatedServiceList.add(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName());
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
        } else if (ServerTypeClassification.INTEGRATION_DAEMON.equals((Object)serverTypeClassification)) {
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), ServerActiveStatus.STARTING);
            IntegrationDaemonOperationalServices integrationDaemonOperationalServices = new IntegrationDaemonOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerId(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
            instance.setOperationalIntegrationDaemon(integrationDaemonOperationalServices);
            List integrationServices = integrationDaemonOperationalServices.initialize(configuration.getIntegrationServicesConfig(), configuration.getDynamicIntegrationGroupsConfig(), (AuditLog)operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceCode(), GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceDevelopmentStatus(), GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceDescription(), GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceWiki()));
            activatedServiceList.addAll(integrationServices);
            activatedServiceList.add(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName());
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
        }
    }

    private void cleanUpRunningServiceInstances(String userId, String serverName, OMAGOperationalServicesInstance instance) {
        String methodName = "cleanUpRunningServiceInstances";
        try {
            this.deactivateRunningServiceInstances(userId, serverName, "cleanUpRunningServiceInstances", instance, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deactivateRunningServiceInstances(String userId, String serverName, String methodName, OMAGOperationalServicesInstance instance, boolean permanentDeactivation) throws InvalidParameterException, PropertyServerException {
        String actionDescription = "Shutdown server";
        if (instance != null) {
            OMRSAuditLog auditLog = instance.getAuditLog();
            if (auditLog != null) {
                auditLog.logMessage("Shutdown server", ServerOpsAuditCode.SERVER_SHUTDOWN_STARTED.getMessageDefinition(new String[]{serverName}), Boolean.toString(permanentDeactivation));
            }
            try {
                if (instance.getOperationalAccessServiceAdminList() != null) {
                    for (AccessServiceAdmin accessServiceAdmin : instance.getOperationalAccessServiceAdminList()) {
                        if (accessServiceAdmin == null) continue;
                        instance.setServerServiceActiveStatus(accessServiceAdmin.getFullServiceName(), ServerActiveStatus.STOPPING);
                        accessServiceAdmin.shutdown();
                        instance.setServerServiceActiveStatus(accessServiceAdmin.getFullServiceName(), ServerActiveStatus.INACTIVE);
                    }
                }
                if (instance.getOperationalViewServiceAdminList() != null) {
                    for (ViewServiceAdmin viewServiceAdmin : instance.getOperationalViewServiceAdminList()) {
                        if (viewServiceAdmin == null) continue;
                        instance.setServerServiceActiveStatus(viewServiceAdmin.getFullServiceName(), ServerActiveStatus.STOPPING);
                        viewServiceAdmin.shutdown();
                        instance.setServerServiceActiveStatus(viewServiceAdmin.getFullServiceName(), ServerActiveStatus.INACTIVE);
                    }
                }
                if (instance.getOperationalOCFMetadataServices() != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalOCFMetadataServices().shutdown();
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalGAFMetadataServices() != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalGAFMetadataServices().shutdown();
                    instance.setServerServiceActiveStatus(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalOIFMetadataServices() != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalOIFMetadataServices().shutdown();
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OIF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalEngineHost() != null) {
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalEngineHost().terminate();
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalIntegrationDaemon() != null) {
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalIntegrationDaemon().terminate();
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalConformanceSuiteServices() != null) {
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalConformanceSuiteServices().terminate(permanentDeactivation);
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalRepositoryServices() != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalRepositoryServices().disconnect(permanentDeactivation);
                    instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                instance.setServerActiveStatus(ServerActiveStatus.INACTIVE);
                this.instanceHandler.removeServerServiceInstance(serverName);
                if (auditLog != null) {
                    auditLog.logMessage("Shutdown server", ServerOpsAuditCode.SERVER_SHUTDOWN_SUCCESS.getMessageDefinition(new String[]{serverName}), Boolean.toString(permanentDeactivation));
                }
            }
            catch (Exception error) {
                if (auditLog != null) {
                    auditLog.logException("Shutdown server", ServerOpsAuditCode.SERVER_SHUTDOWN_ERROR.getMessageDefinition(new String[]{serverName, error.getClass().getName(), error.getMessage()}), Boolean.toString(permanentDeactivation), (Throwable)error);
                }
                throw error;
            }
            this.platformInstanceMap.shutdownServerInstance(userId, serverName, methodName);
        }
    }

    public void deactivateTemporarilyServerList(String userId, List<String> serverNames) {
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                this.shutdownServer(userId, serverName);
            }
        }
    }

    public VoidResponse shutdownServer(String userId, String serverName) {
        String methodName = "shutdownServer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "shutdownServer");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "shutdownServer");
            this.errorHandler.validateUserId(userId, serverName, "shutdownServer");
            this.deactivateRunningServiceInstances(userId, serverName, "shutdownServer", this.instanceHandler.getServerServiceInstance(userId, serverName, "shutdownServer"), false);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "shutdownServer", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse shutdownAndUnregisterServer(String userId, String serverName) {
        String methodName = "shutdownAndUnregisterServer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "shutdownAndUnregisterServer");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "shutdownAndUnregisterServer");
            this.errorHandler.validateUserId(userId, serverName, "shutdownAndUnregisterServer");
            this.deactivateRunningServiceInstances(userId, serverName, "shutdownAndUnregisterServer", this.instanceHandler.getServerServiceInstance(userId, serverName, "shutdownAndUnregisterServer"), true);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "shutdownAndUnregisterServer", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OMAGServerConfigResponse getActiveConfiguration(String userId, String serverName) {
        String methodName = "getActiveConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveConfiguration");
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "getActiveConfiguration");
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "getActiveConfiguration");
            response.setOMAGServerConfig(instance.getOperationalConfiguration());
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getActiveConfiguration", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OMAGServerStatusResponse getActiveServerStatus(String userId, String serverName) {
        String methodName = "getActiveServerStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveServerStatus");
        OMAGServerStatusResponse response = new OMAGServerStatusResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "getActiveServerStatus");
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "getActiveServerStatus");
            response.setServerStatus(instance.getServerStatus());
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getActiveServerStatus", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerServicesListResponse getActiveServices(String userId, String serverName) {
        String methodName = "getActiveServiceListForServer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveServiceListForServer");
        ServerServicesListResponse response = new ServerServicesListResponse();
        try {
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "getActiveServiceListForServer");
            response.setServerName(serverName);
            response.setServerServicesList(instance.getActiveServiceListForServer());
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveServiceListForServer", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOpenMetadataArchiveFile(String userId, String serverName, String fileName) {
        String methodName = "addOpenMetadataArchiveFile";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addOpenMetadataArchiveFile");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addOpenMetadataArchiveFile");
            this.errorHandler.validateUserId(userId, serverName, "addOpenMetadataArchiveFile");
            this.errorHandler.validateFileName(fileName, serverName, "addOpenMetadataArchiveFile");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            Connection newOpenMetadataArchive = configurationFactory.getOpenMetadataArchiveFileConnection(fileName);
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "addOpenMetadataArchiveFile");
            OMRSOperationalServices repositoryServicesInstance = instance.getOperationalRepositoryServices();
            repositoryServicesInstance.addOpenMetadataArchive(serverName, newOpenMetadataArchive, fileName);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addOpenMetadataArchiveFile", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOpenMetadataArchive(String userId, String serverName, Connection connection) {
        String methodName = "addOpenMetadataArchive";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addOpenMetadataArchive");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addOpenMetadataArchive");
            this.errorHandler.validateUserId(userId, serverName, "addOpenMetadataArchive");
            this.errorHandler.validateServerConnection(connection, serverName, "addOpenMetadataArchive");
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "addOpenMetadataArchive");
            OMRSOperationalServices repositoryServicesInstance = instance.getOperationalRepositoryServices();
            repositoryServicesInstance.addOpenMetadataArchive(serverName, connection, "addOpenMetadataArchive");
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addOpenMetadataArchive", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOpenMetadataArchive(String userId, String serverName, OpenMetadataArchive openMetadataArchive) {
        String methodName = "addOpenMetadataArchive";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addOpenMetadataArchive");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addOpenMetadataArchive");
            this.errorHandler.validateUserId(userId, serverName, "addOpenMetadataArchive");
            this.errorHandler.validatePropertyNotNull((Object)openMetadataArchive, "openMetadataArchive", serverName, "addOpenMetadataArchive");
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "addOpenMetadataArchive");
            OMRSOperationalServices repositoryServicesInstance = instance.getOperationalRepositoryServices();
            OpenMetadataArchiveWrapper archiveWrapper = new OpenMetadataArchiveWrapper();
            archiveWrapper.setArchiveContents(openMetadataArchive);
            repositoryServicesInstance.addOpenMetadataArchive(serverName, (OpenMetadataArchiveStore)archiveWrapper, "addOpenMetadataArchive");
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addOpenMetadataArchive", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

