/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serveroperations.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.serveroperations.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerServicesListResponse;
import org.odpi.openmetadata.serveroperations.server.OMAGServerOperationalServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/server-operations/users/{userId}"})
@Tag(name="Server Operations", description="Server operations provides the APIs for querying the status of a running Open Metadata and Governance (OMAG) server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/server-operations"))
public class OMAGServerResource {
    private final OMAGServerOperationalServices serverOperationalServices = new OMAGServerOperationalServices();

    @GetMapping(path={"/servers/{serverName}/instance/configuration"})
    @Operation(summary="getActiveConfiguration", description="Retrieve the configuration document used to start a running instance of a server. The stored configuration document may have changed since the server was started.  This operation makes it possible to verify the configuration values actually being used in the running server. An InvalidParameterException is returned if the server is not running.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document"))
    public OMAGServerConfigResponse getActiveConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.serverOperationalServices.getActiveConfiguration(userId, serverName);
    }

    @GetMapping(path={"/servers/{serverName}/instance/status"})
    @Operation(summary="getActiveServerStatus", description="Retrieve the status for a running instance of a server. This includes the status of each running service. It is used to verify that the required services are running. An InvalidParameterException is returned if the server is not running.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server"))
    public OMAGServerStatusResponse getActiveServerStatus(@PathVariable String userId, @PathVariable String serverName) {
        return this.serverOperationalServices.getActiveServerStatus(userId, serverName);
    }

    @GetMapping(path={"/servers/{serverName}/services"})
    @Operation(summary="getActiveServiceListForServer", description="Return the list of services that are active on the named server", responses={@ApiResponse(responseCode="200", description="List of server services", content={@Content(mediaType="application/json", schema=@Schema(implementation=ServerServicesListResponse.class))})}, externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server"))
    public ServerServicesListResponse getActiveServices(@Parameter(description="calling user") @PathVariable String userId, @Parameter(description="server name") @PathVariable String serverName) {
        return this.serverOperationalServices.getActiveServices(userId, serverName);
    }

    @PostMapping(path={"/servers/{serverName}/instance/open-metadata-archives/file"})
    @Operation(summary="addOpenMetadataArchiveFile", description="An open metadata archive contains metadata types and instances.  This operation loads an open metadata archive that is readable through the connector identified by the connection.  It can be used with OMAG servers that are of type Open Metadata Store.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/open-metadata-archives/"))
    public VoidResponse addOpenMetadataArchiveFile(@PathVariable String userId, @PathVariable String serverName, @RequestBody String fileName) {
        return this.serverOperationalServices.addOpenMetadataArchiveFile(userId, serverName, fileName);
    }

    @PostMapping(path={"/servers/{serverName}/instance/open-metadata-archives/connection"})
    @Operation(summary="addOpenMetadataArchive", description="An open metadata archive contains metadata types and instances.  This operation loads an open metadata archive that is readable through the connector identified by the connection.  It can be used with OMAG servers that are of type Open Metadata Store.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/open-metadata-archives/"))
    public VoidResponse addOpenMetadataArchive(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.serverOperationalServices.addOpenMetadataArchive(userId, serverName, connection);
    }

    @PostMapping(path={"/servers/{serverName}/instance/open-metadata-archives/archive-content"})
    @Operation(summary="addOpenMetadataArchiveContent", description="An open metadata archive contains metadata types and instances.  This operation loads the supplied open metadata archive into the local repository.  It can be used with OMAG servers that are of type Open Metadata Store.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/open-metadata-archives/"))
    public VoidResponse addOpenMetadataArchive(@PathVariable String userId, @PathVariable String serverName, @RequestBody OpenMetadataArchive openMetadataArchive) {
        return this.serverOperationalServices.addOpenMetadataArchive(userId, serverName, openMetadataArchive);
    }
}

