/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;

public class SimpleEventCatalogArchiveBuilder {
    private static final String archiveGUID = "e5114849-4341-4eab-b1b7-5a4b037363c4";
    private static final String archiveName = "SimpleEventCatalog";
    private static final String archiveLicense = "Apache 2.0";
    private static final String archiveDescription = "Sample metadata showing topic assets and event types.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.REPOSITORY_BACKUP;
    private static final String originatorName = "Egeria";
    private static final Date creationDate = new Date(1632046251579L);
    private static final String customerChangeQualifiedName = "global-event-bus/CustomerDomain/Topics/CustomerChange";
    private static final String customerChangeDisplayName = "CustomerChangeTopic";
    private static final String customerChangeDescription = "Topic for distributing updates when a customer status changes.";
    private static final String newCustomerStatusQualifiedName = "global-event-bus/CustomerDomain/EventTypes/NewCustomerStatus";
    private static final String newCustomerStatusDisplayName = "New Customer Status Event Type";
    private static final String newCustomerStatusDescription = "Event payload to notify subscribers that a customer status has changed.";
    private static final String customerIdQualifiedName = "global-event-bus/CustomerDomain/EventAttributes/CustomerIdentifiers/customerId";
    private static final String customerIdDisplayName = "customerId";
    private static final String customerIdDescription = "The unique identifier assigned internally for a customer.";
    private static final String customerIdDataType = "string";
    private static final int customerIdLength = 12;
    private static final String customerNameQualifiedName = "global-event-bus/CustomerDomain/EventAttributes/CustomerIdentifiers/customerName";
    private static final String customerNameDisplayName = "customerName";
    private static final String customerNameDescription = "The name for a customer - as supplied by the customer.";
    private static final String customerNameDataType = "string";
    private static final int customerNameLength = 40;
    private static final String customerStatusQualifiedName = "global-event-bus/CustomerDomain/EventAttributes/CustomerIdentifiers/customerStatus";
    private static final String customerStatusDisplayName = "customerStatus";
    private static final String customerStatusDescription = "The calculated status for a customer indicating their value to the organization.";
    private static final String customerStatusDataType = "string";
    private static final int customerStatusLength = 10;
    private static final String topicAssetTypeName = "KafkaTopic";
    private static final String eventTypeTypeName = "EventType";
    private static final String eventAttributeTypeName = "EventSchemaAttribute";
    private static final String eventTypeListTypeName = "EventTypeList";
    private static final String eventSetTypeName = "EventSet";
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final SimpleCatalogArchiveHelper archiveHelper;

    public SimpleEventCatalogArchiveBuilder(String archiveName, String archiveRootName) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new SimpleCatalogArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, archiveRootName, originatorName, creationDate, 1L, versionName, InstanceProvenanceType.LOCAL_COHORT, null);
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String assetGUID = this.archiveHelper.addAsset(topicAssetTypeName, customerChangeQualifiedName, customerChangeDisplayName, customerChangeDescription, null, null);
        String eventTypeListGUID = this.archiveHelper.addTopLevelSchemaType(assetGUID, eventTypeListTypeName, "global-event-bus/CustomerDomain/Topics/CustomerChange_event_type_list", "CustomerChangeTopic Event Type List", null, null);
        String eventTypeGUID = this.archiveHelper.addTopLevelSchemaType(null, eventTypeTypeName, newCustomerStatusQualifiedName, newCustomerStatusDisplayName, newCustomerStatusDescription, null);
        this.archiveHelper.addSchemaTypeOption(eventTypeListGUID, eventTypeGUID);
        String eventAttributeGUID = this.archiveHelper.addSchemaAttribute(eventAttributeTypeName, null, customerIdQualifiedName, customerIdDisplayName, customerIdDescription, "string", 12, 0, null);
        this.archiveHelper.addAttributeForSchemaType(eventTypeGUID, eventAttributeGUID);
        eventAttributeGUID = this.archiveHelper.addSchemaAttribute(eventAttributeTypeName, null, customerNameQualifiedName, customerNameDisplayName, customerNameDescription, "string", 40, 1, null);
        this.archiveHelper.addAttributeForSchemaType(eventTypeGUID, eventAttributeGUID);
        eventAttributeGUID = this.archiveHelper.addSchemaAttribute(eventAttributeTypeName, null, customerStatusQualifiedName, customerStatusDisplayName, customerStatusDescription, "string", 10, 2, null);
        this.archiveHelper.addAttributeForSchemaType(eventTypeGUID, eventAttributeGUID);
        this.archiveHelper.saveGUIDs();
        return this.archiveBuilder.getOpenMetadataArchive();
    }
}

