/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.ffdc.FileBasedOpenMetadataArchiveStoreConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedOpenMetadataArchiveStoreConnector
extends OpenMetadataArchiveStoreConnector {
    private static final String defaultFilename = "open.metadata.archive";
    private String archiveStoreName = null;
    private static final Logger log = LoggerFactory.getLogger(FileBasedOpenMetadataArchiveStoreConnector.class);

    @Override
    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.archiveStoreName = endpoint.getAddress();
        }
        if (this.archiveStoreName == null) {
            this.archiveStoreName = defaultFilename;
        }
    }

    @Override
    public OpenMetadataArchive getArchiveContents() {
        OpenMetadataArchive newOpenMetadataArchive;
        File archiveStoreFile = new File(this.archiveStoreName);
        try {
            log.debug("Retrieving open metadata archive from file");
            if (this.auditLog != null) {
                String actionDescription = "Opening open metadata archive";
                this.auditLog.logMessage("Opening open metadata archive", FileBasedOpenMetadataArchiveStoreConnectorAuditCode.OPENING_FILE.getMessageDefinition(this.archiveStoreName));
            }
            String configStoreFileContents = FileUtils.readFileToString(archiveStoreFile, "UTF-8");
            ObjectMapper objectMapper = new ObjectMapper();
            newOpenMetadataArchive = objectMapper.readValue(configStoreFileContents, OpenMetadataArchive.class);
        }
        catch (IOException ioException) {
            if (this.auditLog != null) {
                String actionDescription = "Unable to open file";
                this.auditLog.logException("Unable to open file", FileBasedOpenMetadataArchiveStoreConnectorAuditCode.BAD_FILE.getMessageDefinition(this.archiveStoreName, ioException.getClass().getName(), ioException.getMessage()), ioException);
            }
            log.debug("Create empty archive", ioException);
            newOpenMetadataArchive = new OpenMetadataArchive();
        }
        return newOpenMetadataArchive;
    }

    @Override
    public void setArchiveContents(OpenMetadataArchive archiveContents) {
        File archiveStoreFile = new File(this.archiveStoreName);
        try {
            log.debug("Writing open metadata archive store properties: " + archiveContents);
            if (archiveContents == null) {
                archiveStoreFile.delete();
            } else {
                ObjectMapper objectMapper = new ObjectMapper();
                String archiveStoreFileContents = objectMapper.writeValueAsString(archiveContents);
                FileUtils.writeStringToFile(archiveStoreFile, archiveStoreFileContents, (String)null, false);
            }
        }
        catch (IOException ioException) {
            log.debug("Unusable Server config Store :(", ioException);
        }
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        log.debug("Closing Config Store.");
    }
}

